/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.scenegraph;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.biojava.utils.scenegraph.Composite;

public class PaddedContainer
extends Composite {
    private AffineTransform pad = new AffineTransform();

    final void setPadX(double d) {
        this.pad.setToTranslation(d, this.getPadY());
        this.invalidateBounds();
    }

    final void setPadY(double d) {
        this.pad.setToTranslation(this.getPadX(), d);
        this.invalidateBounds();
    }

    final double getPadX() {
        return this.pad.getTranslateX();
    }

    final double getPadY() {
        return this.pad.getTranslateY();
    }

    public PaddedContainer(double d, double d2) {
        this();
        this.pad.setToTranslation(d, d2);
    }

    public PaddedContainer(Point2D point2D) {
        this(point2D.getX(), point2D.getY());
    }

    public PaddedContainer() {
    }

    public Shape calculateBounds() {
        Rectangle2D rectangle2D = super.calculateBounds().getBounds2D();
        double d = this.getPadX();
        double d2 = this.getPadY();
        rectangle2D.setRect(rectangle2D.getX() - d, rectangle2D.getY() - d2, rectangle2D.getWidth() + 2.0 * d, rectangle2D.getHeight() + 2.0 * d2);
        return rectangle2D;
    }

    public AffineTransform getDrawingTransform() {
        AffineTransform affineTransform = (AffineTransform)super.getDrawingTransform().clone();
        affineTransform.concatenate(this.pad);
        return affineTransform;
    }
}

