/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;

public class SuffixTree
implements Serializable {
    private FiniteAlphabet alphabet;
    private SuffixNode root;
    private List symList;
    private List counts;

    public SuffixTree(FiniteAlphabet finiteAlphabet) {
        this.alphabet = finiteAlphabet;
        this.symList = finiteAlphabet.symbols().toList();
        this.counts = new ArrayList();
        this.root = new SimpleNode(finiteAlphabet.size());
    }

    public void addSymbols(SymbolList symbolList, int n) {
        SuffixNode[] suffixNodeArray = new SuffixNode[n];
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            suffixNodeArray[n2] = this.getRoot();
            ++n2;
        }
        int n3 = 1;
        while (n3 <= symbolList.length()) {
            Symbol symbol = symbolList.symbolAt(n3);
            suffixNodeArray[n3 % n] = this.getRoot();
            int n4 = 0;
            while (n4 < n) {
                int n5 = (n3 + n4) % n;
                if (suffixNodeArray[n5] != null) {
                    suffixNodeArray[n5] = this.getChild(suffixNodeArray[n5], symbol);
                    if (suffixNodeArray[n5] != null) {
                        int n6 = n4;
                        nArray[n6] = nArray[n6] + 1;
                        suffixNodeArray[n5].setNumber(suffixNodeArray[n5].getNumber() + 1.0f);
                    }
                }
                ++n4;
            }
            ++n3;
        }
        int n7 = 0;
        while (n7 < n) {
            this.incCounts(n7 + 1, nArray[n7]);
            ++n7;
        }
    }

    public int frequency(int n) {
        return (Integer)this.counts.get(n - 1);
    }

    public FiniteAlphabet getAlphabet() {
        return this.alphabet;
    }

    public SuffixNode getChild(SuffixNode suffixNode, int n) {
        if (!suffixNode.hasChild(n)) {
            suffixNode.addChild(this, n, new SimpleNode(this.alphabet.size()));
        }
        return suffixNode.getChild(n);
    }

    public SuffixNode getChild(SuffixNode suffixNode, Symbol symbol) {
        if (!this.getAlphabet().contains(symbol)) {
            return null;
        }
        int n = this.indexForSymbol(symbol);
        return this.getChild(suffixNode, n);
    }

    public SuffixNode getRoot() {
        return this.root;
    }

    protected void incCounts(int n, int n2) {
        if (n < this.counts.size()) {
            Integer n3 = (Integer)this.counts.get(n - 1);
            Integer n4 = new Integer(n3 + n2);
            this.counts.set(n - 1, n4);
        } else {
            this.counts.add(new Integer(n2));
        }
    }

    public int indexForSymbol(Symbol symbol) {
        return this.symList.indexOf(symbol);
    }

    public int maxLength() {
        return this.counts.size();
    }

    public Symbol symbolForIndex(int n) {
        return (Symbol)this.symList.get(n);
    }

    public static abstract class SuffixNode
    implements Serializable {
        abstract void addChild(SuffixTree var1, int var2, SuffixNode var3);

        abstract SuffixNode getChild(int var1);

        public abstract float getNumber();

        public abstract boolean hasChild(int var1);

        public abstract boolean isTerminal();

        public abstract void setNumber(float var1);
    }

    private static class SimpleNode
    extends SuffixNode {
        private float number = 0.0f;
        private SuffixNode[] child;

        SimpleNode(int n) {
            this.child = new SuffixNode[n];
        }

        void addChild(SuffixTree suffixTree, int n, SuffixNode suffixNode) {
            this.childArray((SuffixTree)suffixTree)[n] = suffixNode;
        }

        private SuffixNode[] childArray(SuffixTree suffixTree) {
            if (this.child == null) {
                this.child = new SuffixNode[suffixTree.getAlphabet().size()];
            }
            return this.child;
        }

        SuffixNode getChild(int n) {
            if (this.hasChild(n)) {
                return this.child[n];
            }
            return null;
        }

        public float getNumber() {
            return this.number;
        }

        public boolean hasChild(int n) {
            return this.child != null && this.child[n] != null;
        }

        public boolean isTerminal() {
            return false;
        }

        public void setNumber(float f) {
            this.number = f;
        }
    }
}

