/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.search;

import java.util.Collections;
import java.util.List;
import org.biojava.bio.Annotatable;
import org.biojava.bio.Annotation;
import org.biojava.bio.search.SeqSimilaritySearchHit;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ObjectUtil;
import org.biojava.utils.contract.Contract;

public class SequenceDBSearchHit
extends AbstractChangeable
implements SeqSimilaritySearchHit,
Annotatable {
    private String sequenceID;
    private double score;
    private double pValue;
    private double eValue;
    private List subHits;
    private Annotation annotation;

    public SequenceDBSearchHit(String string, double d, double d2, double d3, List list, Annotation annotation) {
        Contract.pre(string != null, "sequenceID was null");
        Contract.pre(Double.isNaN(d) ^ true, "score was NaN");
        Contract.pre(list != null, "subHits was null");
        this.sequenceID = string;
        this.score = d;
        this.eValue = d2;
        this.pValue = d3;
        this.subHits = list;
        this.annotation = annotation;
        this.annotation.addChangeListener(ChangeListener.ALWAYS_VETO);
    }

    public Object clone() {
        return this;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!object.getClass().equals(this.getClass())) {
            return false;
        }
        SequenceDBSearchHit sequenceDBSearchHit = (SequenceDBSearchHit)object;
        if (!ObjectUtil.equals(this.score, sequenceDBSearchHit.score)) {
            return false;
        }
        if (!ObjectUtil.equals(this.pValue, sequenceDBSearchHit.pValue)) {
            return false;
        }
        if (!ObjectUtil.equals(this.eValue, sequenceDBSearchHit.eValue)) {
            return false;
        }
        if (!ObjectUtil.equals(this.sequenceID, sequenceDBSearchHit.sequenceID)) {
            return false;
        }
        return ObjectUtil.equals(this.subHits, sequenceDBSearchHit.subHits);
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public double getEValue() {
        return this.eValue;
    }

    public double getPValue() {
        return this.pValue;
    }

    public double getScore() {
        return this.score;
    }

    public String getSequenceID() {
        return this.sequenceID;
    }

    public List getSubHits() {
        return Collections.unmodifiableList(this.subHits);
    }

    public int hashCode() {
        int n = 0;
        n = ObjectUtil.hashCode(n, this.score);
        n = ObjectUtil.hashCode(n, this.pValue);
        n = ObjectUtil.hashCode(n, this.eValue);
        n = ObjectUtil.hashCode(n, this.sequenceID);
        n = ObjectUtil.hashCode(n, this.subHits);
        return n;
    }

    public String toString() {
        return "SequenceDBSearchHit to " + this.getSequenceID() + " with score " + this.getScore();
    }
}

