package com.abien.winery.business.winesearch.domain;

import java.util.ArrayList;
import java.util.Collection;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToMany;

/**
 *
 * @author blog.adam-bien.com
 */
@Entity
public class WineCellar {
    
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    private Long id;
    private String name;
    private String location;

    @ManyToMany(cascade=CascadeType.ALL)
    private Collection<Wine> wines;

    public WineCellar() {
        this.wines = new ArrayList<Wine>();
    }

    public WineCellar(String name, String location) {
        this();
        this.name = name;
        this.location = location;
    }

    public WineCellar add(Wine wine){
        this.wines.add(wine.add(this));
        return this;
    }

    public String getLocation() {
        return location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }




}
