/*
 * Decompiled with CFR 0.152.
 */
package com.sun.errorhandler;

import com.sun.errorhandler.ExceptionHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;

public class DebugClientThread
extends Thread {
    BufferedReader in = null;
    PrintWriter out = null;
    StringBuffer message = new StringBuffer();
    Socket clientSocket = null;
    boolean connected = false;
    boolean connectionFailed = false;
    protected static String errorHost = null;
    private static int errorPort = 0;
    boolean triedToConnect = false;

    protected static void setErrorPort(String newPortVal) {
        errorPort = 24444;
        if (newPortVal != null) {
            try {
                errorPort = Integer.parseInt(newPortVal);
            }
            catch (Exception e) {
                errorPort = 24444;
            }
            if (errorPort < 1 || errorPort > 65536) {
                errorPort = 24444;
            }
        }
    }

    protected static int getErrorPort() {
        return errorPort;
    }

    public void run() {
        this.triedToConnect = true;
        if (errorHost == null) {
            DebugClientThread.displayText("no errorHost, will not talk to creator.");
            this.connected = false;
            this.connectionFailed = true;
            return;
        }
        try {
            this.clientSocket = new Socket(errorHost, errorPort);
            DebugClientThread.displayText("Connected to server " + errorHost + ", port " + errorPort);
            this.connected = true;
        }
        catch (UnknownHostException exc) {
            DebugClientThread.displayText("Could not connect. unknown host " + errorHost + ", port " + errorPort + "; " + exc.getLocalizedMessage());
            this.connectionFailed = true;
        }
        catch (IOException exc) {
            DebugClientThread.displayText("Couldn't get I/O for the connection to " + errorHost + ", port " + errorPort + "; " + exc.getLocalizedMessage());
            this.connectionFailed = true;
        }
        if (this.connectionFailed) {
            this.connected = false;
        } else {
            try {
                this.out = new PrintWriter(this.clientSocket.getOutputStream(), true);
                this.in = new BufferedReader(new InputStreamReader(this.clientSocket.getInputStream()));
            }
            catch (IOException exc) {
                DebugClientThread.displayText("Could not get the socket I/O" + exc.getLocalizedMessage());
                this.connected = false;
            }
        }
        while (this.connected) {
            try {
                String line = this.in.readLine();
                if (line != null) {
                    DebugClientThread.displayText(line);
                    this.message.append(line + "\n");
                    continue;
                }
                this.connected = false;
                DebugClientThread.displayText("Connection closed");
            }
            catch (IOException exc) {
                DebugClientThread.displayText(exc.getLocalizedMessage());
                this.connected = false;
            }
        }
    }

    protected boolean testConnected() {
        while (!this.connected) {
            if (this.connectionFailed) {
                return false;
            }
            try {
                Thread.currentThread();
                Thread.sleep(250L);
            }
            catch (InterruptedException iiee) {
                break;
            }
        }
        return this.connected;
    }

    protected void disconnect() {
        if (this.connected) {
            this.out.close();
            try {
                this.in.close();
            }
            catch (IOException exc) {
                // empty catch block
            }
            try {
                this.clientSocket.close();
            }
            catch (IOException exc) {
                DebugClientThread.displayText("Error occured while disconnecting socket" + exc.getLocalizedMessage());
            }
            this.out = null;
            this.in = null;
            this.clientSocket = null;
            this.connected = false;
        }
    }

    protected void sendMessage(String text) {
        if (this.out != null && this.testConnected()) {
            this.out.println(text);
            this.out.flush();
        }
    }

    protected String getMessage() {
        String str = this.message.toString();
        this.message.delete(0, str.length() - 1);
        return str;
    }

    private static void displayText(String line) {
        if (ExceptionHandler.getDebugLevel() > 0) {
            System.out.println(line);
        }
    }
}

