/*
 * Decompiled with CFR 0.152.
 */
package com.abien.winery.business.winesearch.domain;

import com.abien.winery.business.winesearch.domain.WineCellar;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;

@Entity
@NamedQueries(value={@NamedQuery(name="findWineByName", query="SELECT w FROM Wine w where UPPER(w.name) LIKE :name")})
public class Wine {
    public static final String PREFIX = "com.abien.winery.business.winesearch.domain";
    public static final String findWineByName = "findWineByName";
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private Long id;
    private String name;
    @Column(name="YR")
    private int year;
    private BigDecimal price;
    @ManyToMany(mappedBy="wines")
    private List<WineCellar> wineCellars = new ArrayList<WineCellar>();
    private String imageUrl;

    public Wine() {
    }

    public Wine(String name, String imageUrl, int year, double price) {
        this();
        this.name = name;
        this.year = year;
        this.imageUrl = imageUrl;
        this.price = new BigDecimal(price);
    }

    public Wine add(WineCellar wine) {
        this.wineCellars.add(wine);
        return this;
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public int getAge() {
        return GregorianCalendar.getInstance().get(1) - this.year;
    }
}

