/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.env;

import com.icesoft.faces.env.AuthenticationVerifier;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.Authentication;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.context.SecurityContext;

public class SpringAuthWrapper
implements AuthenticationVerifier {
    private static Log Log = LogFactory.getLog((Class)SpringAuthWrapper.class);
    Authentication authentication;

    public SpringAuthWrapper(Principal principal) {
        this.authentication = (Authentication)principal;
    }

    public boolean isUserInRole(String role) {
        if (null == this.authentication) {
            return false;
        }
        if (Log.isTraceEnabled()) {
            Log.trace((Object)("isUserInRole ROLE: " + role));
        }
        GrantedAuthority[] authorities = this.authentication.getAuthorities();
        if (this.authentication.getPrincipal() == null || authorities == null) {
            return false;
        }
        for (int i = 0; i < authorities.length; ++i) {
            if (!role.equals(authorities[i].getAuthority())) continue;
            return true;
        }
        return false;
    }

    public boolean isReusable() {
        return true;
    }

    public static AuthenticationVerifier getVerifier(HttpServletRequest request) {
        SecurityContext sc;
        Principal principal = request.getUserPrincipal();
        if (principal instanceof Authentication) {
            return new SpringAuthWrapper(principal);
        }
        HttpSession session = request.getSession(false);
        if (session != null && (sc = (SecurityContext)session.getAttribute("SPRING_SECURITY_CONTEXT")) != null) {
            return new SpringAuthWrapper((Principal)sc.getAuthentication());
        }
        return new SpringAuthWrapper(null);
    }
}

