/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.context.effects;

import com.icesoft.faces.context.DOMContext;
import java.util.HashMap;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CurrentStyle {
    public static String CSS_UPDATE_FIELD = "icefacesCssUpdates";
    private String cssString;
    private String lastCssString;
    private static String DISPLAY_ON = "display:block;";
    private static String DISPLAY_OFF = "display:none;";
    private static final Log log = LogFactory.getLog((Class)CurrentStyle.class);

    public CurrentStyle(String cssString) {
        this.cssString = cssString;
    }

    public String getCssString() {
        return this.cssString;
    }

    public String getLastCssString() {
        return this.lastCssString;
    }

    public void setLastCssString(String lastCssString) {
        this.lastCssString = lastCssString;
    }

    public static void apply(FacesContext facesContext, UIComponent uiComponent) {
        CurrentStyle.apply(facesContext, uiComponent, null, null);
    }

    public static void apply(FacesContext facesContext, UIComponent uiComponent, Element targetElement, String style) {
        CurrentStyle currentStyle;
        if (targetElement == null) {
            Element root;
            DOMContext domContext = DOMContext.getDOMContext(facesContext, uiComponent);
            Node node = domContext.getRootNode();
            if (node == null || !(node instanceof Element)) {
                return;
            }
            targetElement = root = (Element)node;
        }
        String jspStyle = (String)uiComponent.getAttributes().get("style");
        if (log.isTraceEnabled() && jspStyle != null) {
            log.trace((Object)("Existing style [" + jspStyle + "]"));
        }
        if (style != null) {
            if (jspStyle == null) {
                jspStyle = "";
            }
            jspStyle = jspStyle + style;
        }
        Boolean visibility = (Boolean)uiComponent.getAttributes().get("visible");
        boolean visible = true;
        if (visibility != null) {
            visible = visibility;
        }
        if ((currentStyle = (CurrentStyle)uiComponent.getAttributes().get("currentStyle")) != null) {
            String appendedStyle = currentStyle.cssString;
            currentStyle.lastCssString = currentStyle.cssString;
            if (appendedStyle != null) {
                jspStyle = jspStyle == null ? appendedStyle : jspStyle + ";" + appendedStyle;
            }
        }
        if (visible) {
            int startI;
            if (jspStyle != null && (startI = jspStyle.indexOf(DISPLAY_OFF)) != -1) {
                String start = "";
                if (startI > 0) {
                    start = jspStyle.substring(0, startI);
                }
                int endI = startI + DISPLAY_OFF.length();
                String end = "";
                if (endI < jspStyle.length()) {
                    end = jspStyle.substring(endI);
                }
                jspStyle = start + end;
            }
        } else {
            jspStyle = jspStyle == null ? DISPLAY_OFF : jspStyle + DISPLAY_OFF;
        }
        if (log.isTraceEnabled() && jspStyle != null) {
            log.trace((Object)("JSP Style [" + jspStyle + "]"));
        }
        if (targetElement != null) {
            if (jspStyle != null && jspStyle.length() > 0) {
                targetElement.setAttribute("style", jspStyle);
            } else {
                targetElement.removeAttribute("style");
            }
        }
    }

    public static Map decode(FacesContext facesContext) {
        Map parameters = facesContext.getExternalContext().getRequestParameterMap();
        String cssUpdate = (String)parameters.get(CSS_UPDATE_FIELD);
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        String oldCssUpdate = (String)requestMap.get(CSS_UPDATE_FIELD);
        if (cssUpdate == null || cssUpdate.length() == 0) {
            return null;
        }
        HashMap<String, String> updates = null;
        if (!cssUpdate.equals(oldCssUpdate)) {
            updates = new HashMap<String, String>();
            int rightBrace = 0;
            do {
                if ((rightBrace = cssUpdate.indexOf("}")) == -1) continue;
                String update = cssUpdate.substring(0, ++rightBrace);
                cssUpdate = cssUpdate.substring(rightBrace);
                int leftBrace = update.indexOf("{");
                String id = update.substring(0, leftBrace);
                String style = update.substring(++leftBrace, update.length() - 1);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Adding id[" + id + "] Style [" + style + "]"));
                }
                updates.put(id, style);
            } while (rightBrace != -1);
            facesContext.getExternalContext().getSessionMap().put(CurrentStyle.class.getName(), updates);
            requestMap.put(CSS_UPDATE_FIELD, cssUpdate);
        }
        return updates;
    }

    public static void decode(FacesContext facesContext, UIComponent uiComponent) {
        block11: {
            ValueBinding vb;
            CurrentStyle cs;
            CurrentStyle.decode(facesContext);
            Map map = (Map)facesContext.getExternalContext().getSessionMap().get(CurrentStyle.class.getName());
            if (map == null) {
                return;
            }
            if (uiComponent == null) {
                return;
            }
            String clientId = uiComponent.getClientId(facesContext);
            String style = (String)map.get(clientId);
            if (style == null) {
                return;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("Decode Applying Style to [" + clientId + "] Css [" + style + "]"));
            }
            if ((cs = (CurrentStyle)uiComponent.getAttributes().get("currentStyle")) != null) {
                cs.cssString = style;
            } else {
                cs = new CurrentStyle(style);
                uiComponent.getAttributes().put("currentStyle", new CurrentStyle(style));
            }
            Boolean value = Boolean.valueOf("true");
            if (cs.cssString.endsWith(DISPLAY_OFF)) {
                value = Boolean.valueOf("false");
            }
            if ((vb = uiComponent.getValueBinding("visible")) == null) {
                uiComponent.getAttributes().put("visible", value);
            } else {
                try {
                    vb.setValue(facesContext, (Object)value);
                }
                catch (Exception e) {
                    if (!log.isErrorEnabled()) break block11;
                    log.error((Object)("Exception setting visible. Value Binding [" + vb.getExpressionString() + "]"), (Throwable)e);
                }
            }
        }
    }
}

