/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.iterators.ArrayIterator;
import org.apache.commons.collections.iterators.EnumerationIterator;

public class CollectionUtils {
    public static final Iterator EMPTY_ITERATOR = IteratorUtils.EMPTY_ITERATOR;

    public static Collection union(Collection collection, Collection collection2) {
        ArrayList arrayList = new ArrayList();
        Map map = CollectionUtils.getCardinalityMap(collection);
        Map map2 = CollectionUtils.getCardinalityMap(collection2);
        HashSet hashSet = new HashSet(collection);
        hashSet.addAll(collection2);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            int n = 0;
            int n2 = Math.max(CollectionUtils.getFreq(e, map), CollectionUtils.getFreq(e, map2));
            while (n < n2) {
                arrayList.add(e);
                ++n;
            }
        }
        return arrayList;
    }

    public static Collection intersection(Collection collection, Collection collection2) {
        ArrayList arrayList = new ArrayList();
        Map map = CollectionUtils.getCardinalityMap(collection);
        Map map2 = CollectionUtils.getCardinalityMap(collection2);
        HashSet hashSet = new HashSet(collection);
        hashSet.addAll(collection2);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            int n = 0;
            int n2 = Math.min(CollectionUtils.getFreq(e, map), CollectionUtils.getFreq(e, map2));
            while (n < n2) {
                arrayList.add(e);
                ++n;
            }
        }
        return arrayList;
    }

    public static Collection disjunction(Collection collection, Collection collection2) {
        ArrayList arrayList = new ArrayList();
        Map map = CollectionUtils.getCardinalityMap(collection);
        Map map2 = CollectionUtils.getCardinalityMap(collection2);
        HashSet hashSet = new HashSet(collection);
        hashSet.addAll(collection2);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            int n = 0;
            int n2 = Math.max(CollectionUtils.getFreq(e, map), CollectionUtils.getFreq(e, map2)) - Math.min(CollectionUtils.getFreq(e, map), CollectionUtils.getFreq(e, map2));
            while (n < n2) {
                arrayList.add(e);
                ++n;
            }
        }
        return arrayList;
    }

    public static Collection subtract(Collection collection, Collection collection2) {
        ArrayList arrayList = new ArrayList(collection);
        Iterator iterator = collection2.iterator();
        while (iterator.hasNext()) {
            arrayList.remove(iterator.next());
        }
        return arrayList;
    }

    public static boolean containsAny(Collection collection, Collection collection2) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (!collection2.contains(iterator.next())) continue;
            return true;
        }
        return false;
    }

    public static Map getCardinalityMap(Collection collection) {
        HashMap hashMap = new HashMap();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Integer n = (Integer)hashMap.get(e);
            if (null == n) {
                hashMap.put(e, new Integer(1));
                continue;
            }
            hashMap.put(e, new Integer(n + 1));
        }
        return hashMap;
    }

    public static boolean isSubCollection(Collection collection, Collection collection2) {
        Map map = CollectionUtils.getCardinalityMap(collection);
        Map map2 = CollectionUtils.getCardinalityMap(collection2);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (CollectionUtils.getFreq(e, map) <= CollectionUtils.getFreq(e, map2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isProperSubCollection(Collection collection, Collection collection2) {
        return CollectionUtils.isSubCollection(collection, collection2) && !CollectionUtils.isEqualCollection(collection, collection2);
    }

    public static boolean isEqualCollection(Collection collection, Collection collection2) {
        if (collection.size() != collection2.size()) {
            return false;
        }
        Map map = CollectionUtils.getCardinalityMap(collection);
        Map map2 = CollectionUtils.getCardinalityMap(collection2);
        if (map.size() != map2.size()) {
            return false;
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (CollectionUtils.getFreq(k, map) == CollectionUtils.getFreq(k, map2)) continue;
            return false;
        }
        return true;
    }

    public static int cardinality(Object object, Collection collection) {
        int n = 0;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if ((null != object || null != e) && !object.equals(e)) continue;
            ++n;
        }
        return n;
    }

    public static Object find(Collection collection, Predicate predicate) {
        if (collection != null && predicate != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!predicate.evaluate(e)) continue;
                return e;
            }
        }
        return null;
    }

    public static void forAllDo(Collection collection, Closure closure) {
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                closure.execute(e);
            }
        }
    }

    public static void filter(Collection collection, Predicate predicate) {
        if (collection != null && predicate != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (predicate.evaluate(e)) continue;
                iterator.remove();
            }
        }
    }

    public static void transform(Collection collection, Transformer transformer) {
        if (collection != null && transformer != null) {
            if (collection instanceof List) {
                List list = (List)collection;
                ListIterator<Object> listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    Object e = listIterator.next();
                    listIterator.set(transformer.transform(e));
                }
            } else {
                Collection collection2 = CollectionUtils.collect(collection, transformer);
                collection.clear();
                collection.addAll(collection2);
            }
        }
    }

    public static Collection select(Collection collection, Predicate predicate) {
        ArrayList arrayList = new ArrayList(collection.size());
        CollectionUtils.select(collection, predicate, arrayList);
        return arrayList;
    }

    public static void select(Collection collection, Predicate predicate, Collection collection2) {
        if (collection != null && predicate != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!predicate.evaluate(e)) continue;
                collection2.add(e);
            }
        }
    }

    public static Collection collect(Collection collection, Transformer transformer) {
        ArrayList arrayList = new ArrayList(collection.size());
        CollectionUtils.collect(collection, transformer, arrayList);
        return arrayList;
    }

    public static Collection collect(Iterator iterator, Transformer transformer) {
        ArrayList arrayList = new ArrayList();
        CollectionUtils.collect(iterator, transformer, arrayList);
        return arrayList;
    }

    public static Collection collect(Collection collection, Transformer transformer, Collection collection2) {
        if (collection != null) {
            return CollectionUtils.collect(collection.iterator(), transformer, collection2);
        }
        return collection2;
    }

    public static Collection collect(Iterator iterator, Transformer transformer, Collection collection) {
        if (iterator != null && transformer != null) {
            while (iterator.hasNext()) {
                Object e = iterator.next();
                Object object = transformer.transform(e);
                collection.add(object);
            }
        }
        return collection;
    }

    public static void addAll(Collection collection, Iterator iterator) {
        while (iterator.hasNext()) {
            collection.add(iterator.next());
        }
    }

    public static void addAll(Collection collection, Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            collection.add(enumeration.nextElement());
        }
    }

    public static void addAll(Collection collection, Object[] objectArray) {
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            collection.add(objectArray[n]);
            ++n;
        }
    }

    public static Object index(Object object, int n) {
        return CollectionUtils.index(object, new Integer(n));
    }

    public static Object index(Object object, Object object2) {
        Map map;
        if (object instanceof Map && (map = (Map)object).containsKey(object2)) {
            return map.get(object2);
        }
        int n = -1;
        if (object2 instanceof Integer) {
            n = (Integer)object2;
        }
        if (n < 0) {
            return object;
        }
        if (object instanceof Map) {
            Map map2 = (Map)object;
            Iterator iterator = map2.keySet().iterator();
            return CollectionUtils.index(iterator, n);
        }
        if (object instanceof List) {
            return ((List)object).get(n);
        }
        if (object instanceof Object[]) {
            return ((Object[])object)[n];
        }
        if (object instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)object;
            while (enumeration.hasMoreElements()) {
                if (--n == -1) {
                    return enumeration.nextElement();
                }
                enumeration.nextElement();
            }
        } else {
            if (object instanceof Iterator) {
                return CollectionUtils.index((Iterator)object, n);
            }
            if (object instanceof Collection) {
                Iterator iterator = ((Collection)object).iterator();
                return CollectionUtils.index(iterator, n);
            }
        }
        return object;
    }

    private static Object index(Iterator iterator, int n) {
        while (iterator.hasNext()) {
            if (--n == -1) {
                return iterator.next();
            }
            iterator.next();
        }
        return iterator;
    }

    public static Iterator getIterator(Object object) {
        if (object instanceof Iterator) {
            return (Iterator)object;
        }
        if (object instanceof Collection) {
            return ((Collection)object).iterator();
        }
        if (object instanceof Object[]) {
            return new ArrayIterator(object);
        }
        if (object instanceof Enumeration) {
            return new EnumerationIterator((Enumeration)object);
        }
        if (object instanceof Map) {
            return ((Map)object).values().iterator();
        }
        if (object != null && object.getClass().isArray()) {
            return new ArrayIterator(object);
        }
        return null;
    }

    public static void reverseArray(Object[] objectArray) {
        int n = 0;
        int n2 = objectArray.length - 1;
        while (n2 > n) {
            Object object = objectArray[n2];
            objectArray[n2] = objectArray[n];
            objectArray[n] = object;
            --n2;
            ++n;
        }
    }

    private static final int getFreq(Object object, Map map) {
        try {
            return (Integer)map.get(object);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        return 0;
    }

    public static Collection predicatedCollection(Collection collection, Predicate predicate) {
        return new PredicatedCollection(collection, predicate);
    }

    static class CollectionWrapper
    implements Collection {
        protected final Collection collection;

        public CollectionWrapper(Collection collection) {
            if (collection == null) {
                throw new IllegalArgumentException("Collection must not be null");
            }
            this.collection = collection;
        }

        public int size() {
            return this.collection.size();
        }

        public boolean isEmpty() {
            return this.collection.isEmpty();
        }

        public boolean contains(Object object) {
            return this.collection.contains(object);
        }

        public Iterator iterator() {
            return this.collection.iterator();
        }

        public Object[] toArray() {
            return this.collection.toArray();
        }

        public Object[] toArray(Object[] objectArray) {
            return this.collection.toArray(objectArray);
        }

        public boolean add(Object object) {
            return this.collection.add(object);
        }

        public boolean remove(Object object) {
            return this.collection.remove(object);
        }

        public boolean containsAll(Collection collection) {
            return this.collection.containsAll(collection);
        }

        public boolean addAll(Collection collection) {
            return this.collection.addAll(collection);
        }

        public boolean removeAll(Collection collection) {
            return this.collection.removeAll(collection);
        }

        public boolean retainAll(Collection collection) {
            return this.collection.retainAll(collection);
        }

        public void clear() {
            this.collection.clear();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            return this.collection.equals(object);
        }

        public int hashCode() {
            return this.collection.hashCode();
        }

        public String toString() {
            return this.collection.toString();
        }
    }

    static class PredicatedCollection
    extends CollectionWrapper {
        protected final Predicate predicate;

        public PredicatedCollection(Collection collection, Predicate predicate) {
            super(collection);
            if (predicate == null) {
                throw new IllegalArgumentException("Predicate must not be null");
            }
            this.predicate = predicate;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.validate(iterator.next());
            }
        }

        public boolean add(Object object) {
            this.validate(object);
            return this.collection.add(object);
        }

        public boolean addAll(Collection collection) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.validate(iterator.next());
            }
            return this.collection.addAll(collection);
        }

        protected void validate(Object object) {
            if (!this.predicate.evaluate(object)) {
                throw new IllegalArgumentException("Cannot add Object - Predicate rejected it");
            }
        }
    }

    static class SynchronizedCollection {
        protected final Collection collection;

        public SynchronizedCollection(Collection collection) {
            if (collection == null) {
                throw new IllegalArgumentException("Collection must not be null");
            }
            this.collection = collection;
        }

        public synchronized int size() {
            return this.collection.size();
        }

        public synchronized boolean isEmpty() {
            return this.collection.isEmpty();
        }

        public synchronized boolean contains(Object object) {
            return this.collection.contains(object);
        }

        public Iterator iterator() {
            return this.collection.iterator();
        }

        public synchronized Object[] toArray() {
            return this.collection.toArray();
        }

        public synchronized Object[] toArray(Object[] objectArray) {
            return this.collection.toArray(objectArray);
        }

        public synchronized boolean add(Object object) {
            return this.collection.add(object);
        }

        public synchronized boolean remove(Object object) {
            return this.collection.remove(object);
        }

        public synchronized boolean containsAll(Collection collection) {
            return this.collection.containsAll(collection);
        }

        public synchronized boolean addAll(Collection collection) {
            return this.collection.addAll(collection);
        }

        public synchronized boolean removeAll(Collection collection) {
            return this.collection.removeAll(collection);
        }

        public synchronized boolean retainAll(Collection collection) {
            return this.collection.retainAll(collection);
        }

        public synchronized void clear() {
            this.collection.clear();
        }

        public synchronized boolean equals(Object object) {
            return this.collection.equals(object);
        }

        public synchronized int hashCode() {
            return this.collection.hashCode();
        }

        public synchronized String toString() {
            return this.collection.toString();
        }
    }

    static class UnmodifiableCollection
    extends CollectionWrapper {
        public UnmodifiableCollection(Collection collection) {
            super(collection);
        }

        public boolean add(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public Iterator iterator() {
            return new UnmodifiableIterator(this.collection.iterator());
        }
    }

    static class UnmodifiableIterator
    implements Iterator {
        protected final Iterator iterator;

        public UnmodifiableIterator(Iterator iterator) {
            if (iterator == null) {
                throw new IllegalArgumentException("Iterator must not be null");
            }
            this.iterator = iterator;
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            return this.iterator.next();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

