### labview.ppc.make - the MPW make file for creating a debugging version of
#		LabVIEW on the PowerPC.
#
#		Created by Rob Dye. 12/9/93
#
#		Optional Make command line defines:
#			ExtraDefs - is passed on to the C compiler and Rez command lines
#				Example:
#					Make -f labview.ppc.make -d "ExtraDefs=-d RUNONLY=1"
#
#			TargSuf - specifies a suffix for the this builds objects and app
#				Example:
#					Make -f labview.ppc.make -d "TargSuf=.app"
#
#			MkSymOpt -	is passed on the the MakeSym command line
#				Example:
#					Make -f labview.ppc.make -d "MkSymOpt=-noTypes"
#
#			CSymOpt - compile symbol option: on,off
#				Default: "CSymOpt=off"
#
#			COptOpt - compile optimization option: off,local,size,speed
#				Default: "COptOpt=off"
#
#			LinkSymOpt - Link and MakeSym symbol option: on,big,off
#				Default: "LinkSymOpt=on"
#

plat			=	PPC
TargSuf 		=	
ExtraDefs 		=	-prefix :MACextras.h -d Shipping=1 -d NDEBUG=1 -d NO_CONST=1 -ignorepragma enumsalwaysint -opt speed
Primary			=	mesa.mrc.o


# Object directory variables. The objects are redirected into a special
#	dir so that they don't pollute the source dir and so that we can
#	have a separate dir for 68K objects.
mesaObj	= :src:{plat}obj{TargSuf}:

# If the compiler supports header dump files use this variable
#	Currently only the MPW C (68K) compiler supports it.
HeaderDump	=

MesaObjects = 
		{mesaObj}alpha.c.o			
		{mesaObj}accum.c.o			
		{mesaObj}drawpix.c.o		
		{mesaObj}dlist.c.o			
		{mesaObj}depth.c.o			
		{mesaObj}copypix.c.o		
		{mesaObj}context.c.o		
		{mesaObj}xform.c.o			
		{mesaObj}colortab.c.o		
		{mesaObj}fog.c.o			
		{mesaObj}clip.c.o			
		{mesaObj}blend.c.o			
		{mesaObj}bitmap.c.o			
		{mesaObj}attrib.c.o			
		{mesaObj}hash.c.o			
		{mesaObj}apiext.c.o			
		{mesaObj}api2.c.o			
		{mesaObj}api1.c.o			
		{mesaObj}alphabuf.c.o		
		{mesaObj}winpos.c.o			
		{mesaObj}vbxform.c.o		
		{mesaObj}vbrender.c.o		
		{mesaObj}vb.c.o				
		{mesaObj}vbfill.c.o			
		{mesaObj}varray.c.o			
		{mesaObj}triangle.c.o		
		{mesaObj}texture.c.o		
		{mesaObj}texstate.c.o		
		{mesaObj}texobj.c.o			
		{mesaObj}teximage.c.o		
		{mesaObj}stencil.c.o		
		{mesaObj}span.c.o			
		{mesaObj}shade.c.o			
		{mesaObj}scissor.c.o		
		{mesaObj}rect.c.o			
		{mesaObj}readpix.c.o		
		{mesaObj}rastpos.c.o		
		{mesaObj}quads.c.o			
		{mesaObj}polygon.c.o		
		{mesaObj}points.c.o			
		{mesaObj}pointers.c.o		
		{mesaObj}pixel.c.o			
		{mesaObj}pb.c.o				
		{mesaObj}matrix.c.o			
		{mesaObj}masking.c.o		
		{mesaObj}logic.c.o			
		{mesaObj}lines.c.o			
		{mesaObj}light.c.o			
		{mesaObj}image.c.o			
		{mesaObj}get.c.o			
		{mesaObj}feedback.c.o		
		{mesaObj}eval.c.o			
		{mesaObj}enable.c.o			
		{mesaObj}misc.c.o			
		{mesaObj}mmath.c.o			
		{mesaObj}zoom.c.o			
		{mesaObj}AGLMem.c.o			
		{mesaObj}MACExtras.c.o		
		{mesaObj}:OSMesa:osmesa.c.o

RezSources = 
RezDepends = {RezSources} 


### Normal build

LIBS =	

C			= MrC
CPP			= MrCpp
CSymOpt		= off
COptOpt		= local
CAlignOpts	= -align mac68k
COptions	= -i :src: -i :include:	-i :include:GL:	
				-enum int		# enums are size of int	
				-proto strict	# require prototypes	
				-shared_lib_export on 					
				-export_list :exportList.trash			
				-ldsize 128 	# long doubles are 128 bits		
				-w 2			# turns off "unintended assignment" warning		
				-w 7			# turns off "possible extraneous ';'" warning	
				-w 29			# turns off "unused local/parameter" warning	
				-traceback
CPPOptions	= -i :src: -i :include:	-i :include:GL	
				-enum int		# enums are size of int	
				-shared_lib_export on 					
				-export_list :exportList.trash			
				-ldsize 128 	# long doubles are 128 bits		
				-w 2			# turns off "unintended assignment" warning		
				#-w 7			# turns off "possible extraneous ';'" warning	
				#-w 29			# turns off "unused local/parameter" warning	
				-traceback

LINK		= PPCLink
LinkSymOpt	= off
LINKOPTS	= -p -mf -xm library

DELETE		= Delete
DELETEOPTS	= -i :src: -i :include: -i :include:GL:



###		default C source dependency and build rules
.c.o		.c
	Echo nn'####' `Date`n'##' Compiling {depDir}{default}.c ...
	{C} -sym {CSymOpt} -opt {COptOpt} {CAlignOpts} {COptions} {ExtraDefs} 
		{depDir}{default}.c -o {targ}
	if {status} != 0
		set LVMakeFailed 1
	end


.c.o.sym		.c
	Echo nn'####' `Date`n'##' Compiling symbol-enabled {depDir}{default}.c ...
	{C} -sym on	 {CAlignOpts} {COptions} {ExtraDefs} 
		{depDir}{default}.c -o {targ}
	if {status} != 0
		set LVMakeFailed 1
	end


.c.o.local		.c
	Echo nn'####' `Date`n'##' Compiling local optimized {depDir}{default}.c ...
	{C} -sym off -opt local {CAlignOpts} {COptions} {ExtraDefs} 
		{depDir}{default}.c -o {targ}
	if {status} != 0
		set LVMakeFailed 1
	end


.c.o.opt		.c
	Echo nn'####' `Date`n'##' Compiling optimized {depDir}{default}.c ...
	{C} -sym off -opt speed {CAlignOpts} {COptions} {ExtraDefs} 
		{depDir}{default}.c -o {targ}
	if {status} != 0
		set LVMakeFailed 1
	end


###		default C++ source dependency and build rules
.cpp.o		.cpp
	Echo nn'####' `Date`n'##' Compiling {depDir}{default}.cpp ...
	{CPP} -sym {CSymOpt} -opt {COptOpt} {CAlignOpts} {CPPOptions} {ExtraDefs} 
		{depDir}{default}.cpp -o {targ}
	if {status} != 0
		set LVMakeFailed 1
	end


.cpp.o.sym		.cpp
	Echo nn'####' `Date`n'##' Compiling symbol-enabled {depDir}{default}.cpp ...
	{CPP} -sym on	 {CAlignOpts} {CPPOptions} {ExtraDefs} 
		{depDir}{default}.cpp -o {targ}
	if {status} != 0
		set LVMakeFailed 1
	end


.cpp.o.local		.cpp
	Echo nn'####' `Date`n'##' Compiling local optimized {depDir}{default}.cpp ...
	{CPP} -sym off -opt local {CAlignOpts} {CPPOptions} {ExtraDefs} 
		{depDir}{default}.cpp -o {targ}
	if {status} != 0
		set LVMakeFailed 1
	end


.cpp.o.opt		.cpp
	Echo nn'####' `Date`n'##' Compiling optimized {depDir}{default}.cpp ...
	{CPP} -sym off -opt speed {CAlignOpts} {CPPOptions} {ExtraDefs} 
		{depDir}{default}.cpp -o {targ}
	if {status} != 0
		set LVMakeFailed 1
	end


###		default assembly dependency and build rules
.s.o		.s
	Echo nn'####' `Date`n'##' Assembling {depDir}{default}.s ...
	{ASM} {AsmOptions} {depDir}{default}.s -o {targ}
	if {status} != 0
		set LVMakeFailed 1
	end


###		Object directory dependencies
{mesaObj} 	:src:


###
###		Default target -  Everything

All			{Primary} # {Primary}.xSYM


###
###		Primary target -  Resource file dependency and build rules
###
#{Primary}		 {RezDepends}
#	If {LVMakeFailed}
#		Echo nn'####' `Date`n'##' Something failed. Exiting.
#		Exit 1
#	End
#	flush
#	Echo nn'####' `Date`n'##' Calling Rez ...
#	If `Exists {Targ}` != "" ; delete -y {Targ}; End
#	{REZ} {RezOptions} -o {Targ} {ExtraDefs} {RezSources}
#	Echo nn'####' `Date`n'##' Finished.
#	Beep


###
###		Primary target
{Primary} 	 {mesaObjects} {LIBS} 
	If {LVMakeFailed}
		Echo nn'####' `Date`n'##' Something failed. Exiting.
		Exit 1
	End
	flush
	Echo nn'####' `Date`n'##' Linking ...
	{LINK} -sym {LinkSymOpt} {LINKOPTS}			
			-o {Targ} {mesaObjects} {LIBS}
	If {status} != 0
		Echo nn'####' `Date`n'##' {LINK} returned status of {status}. Exiting.
		Exit 1
	End
	Echo nn'####' `Date`n'##' Adding cfrg ...
	set line "`files -n -x b {Targ}`"
	if "{line}" =~ /{Targ}[ t]+([0-9]+)1b/
		set sz "-d kCFRGLength="{1}
	else
		Echo nn'####' `Date`n'##' Could not find size of data fork for cfrg. Exiting.
		Exit 1
	end
	Echo nn'####' `Date`n'##' Finished.
	Beep

###
###		Secondary target -	the symbol file simply depends on the xCOFF
{Primary}.xSYM		 {Primary}.xcoff
	flush
	Echo nn'####' `Date`n'##' Calling MakeSYM ...
	MakeSYM -o {Targ} -v -sym {LinkSymOpt} {mksymopt} -i :src: -i :include: -i :include:GL: -r {Primary}.xcoff
	Delete {Primary}.xlines
	Echo nn'####' `Date`n'##' Finished.
	Beep



###		Target for making all files needed by MWerks
# MWerks			AsmObj

# MWerks			:mac:lvcfrag.r
#	{REZ} -o lvcfrag.rsrc -t RSRC -c Doug :mac:lvcfrag.r

###		Target for making all the assembly objects
# AsmObj	


###		Target for listing all objects in a form that can be used by Make
echoObj		
	For ob in {mesaObjects}
		Echo tt {ob}tt''
	end | sort


###		Target for removing all objects
clean	
	{DELETE} {DELETEOPTS} {mesaObjects}



MDOpts =	-c 				# don't generate obj file	
			-p 				# write progress to stdout	
			-opt off 		# no optimizing for compile speed	
			-w off 			# turn off all warnings		
			-align mac68k								
			-i :src: -i :include: -i :include:GL:										
			-ldsize 128		# could affect what headers are included

MesaDepTmp	=	:deps.mesa
AllDepTmp	=	:deps.all
ThisMakeFile=	:mesaGL.ppc.make
NewMakeFile =	{ThisMakeFile}.new
###		Target for making all header dependencies
depend	 mesadepend
	catenate {MesaDepTmp} > {AllDepTmp}
	streamedit {ThisMakeFile} 
		-e '/### DO NOT DELETE THIS LINE/ Exit' 
		> {NewMakeFile}
	catenate {AllDepTmp} >> {NewMakeFile}


###		Target for making all header dependencies
mesadepend	
	Set Exit 0
	set outfile {MesaDepTmp}
	set dir :src:
	For f in {dir}[a-zA_Z0-9_]+.c[p]*
		if "{f}" =~ /.cpp/
			set compiler MrCpp
		else
			set compiler MrC
		end
		echo xxxTARGET{f}	# marker for perl script
		{compiler} {MDOpts} "{f}"	# writes progress to stderr!
		echo xxxENDTARGET	# marker for perl script
		# redirect to file because pipe only sends stdout
	End  {outfile}.tmp
	perl :MungeMrCDepends.pl {outfile}.tmp > {outfile}
	Set Exit 1


###		Target for bringing all objects up to date
uptodate	
	Setfile -m . {MesaObjects}


###		Per object file dependencies
### DO NOT DELETE THIS LINE - MAKEDEPENDS DEPENDS ON IT