/* Datei  : SampleW.CPP
   Autoren: Doering, Gemkow, Woog
   Datum  : 10.09.94

   Beispiel-DLL zur PASCAL-C-Kopplung unter
   Windows und DPMI.                                    */

extern "C" {
#include <windows.h>
#include <math.h>
#include <string.h>

#define DLL_EXP far pascal _export

struct tSampleRec
  {
  int    i;
  double d;
  double *ad;
  int    cd;     /* Anzahl der double-Werte in ad */
  char   sz;     /* Array von 64 char             */
  };

typedef void far pascal (*pWrFunc)(double, unsigned char);

HINSTANCE hDllInstance;

int DLL_EXP AddInteger(int iValueA, int iValueB);
char far *DLL_EXP AppendString(char far *a, char far *b);
void DLL_EXP UniFunc(double dX, int iMode, pWrFunc fn);
double DLL_EXP EvalPoly(int iGrade, double *A, double dX);
void DLL_EXP GetRecord(tSampleRec *r);

/* Jede DLL enthaelt eine Funktion LibMain.             */
int FAR PASCAL LibMain( HINSTANCE hInstance,
                        WORD wDataSegment,
                        WORD wHeapSize,
                        LPSTR lpszCmdLine )
  {
  hDllInstance= hInstance;
  if ( wHeapSize != 0 ) UnlockData( 0 );
  return 1;
  }


/* Jede DLL enthaelt auch eine Funktion WEP.            */
int FAR PASCAL WEP ( int bSystemExit )
  {
  return 1;
  }

int DLL_EXP AddInteger(int iValueA, int iValueB)
  {
  return iValueA+ iValueB;
  }

/* Verkettet a mit b und liefert Zeiger auf a zurueck.
   Der Puffer a muss genug Platz fuer den Gesamtstring
   haben.                                               */
char far *DLL_EXP AppendString(char far *a, char far *b)
  {
  return strcat(a,b);
  }

/* Mathematische Funktion berechnen Werte, die ueber
   die Callback-Routine  fn  ausgeschrieben werden.
   Auf PCs ohne Coprozessor wuerde die Sinusberechnung
   einen Laufzeitfehler bringen. In diesem Fall wird
   der Sinus nicht berechnet.                           */
void DLL_EXP UniFunc(double dX, int iMode, pWrFunc fn)
  {
  if (fn!=0)
    {
      switch (iMode)
      {
      case 0 : fn(dX*dX, TRUE); break;
      case 1 : fn(sqrt(dX), TRUE); break;
      case 2 : if (GetWinFlags() & WF_80x87)
                 fn(sin(dX), TRUE);
               else
                 fn(0.0, FALSE); 
               break;
      case 3 : fn(log(dX), TRUE); break;
      default: fn(0.0, FALSE);
      };
    };
  }

/* Polynomberechnung
   
    y = a(n)*x^n+ a(n-1)*x^(n-1)+ ... + a(1)*x+ a(0)
    Wiederholtes Ausklammern von x fuehrt zu:
    y = (...(a(n)*x+ a(n-1))*x+ ...+a(1))*x+a(0)        */
double DLL_EXP EvalPoly(int iGrade, double *A, double dX)
  {
  double dY;
  int    i;
  if ((A!=0) && (iGrade>=0))
    {
    dY= A[iGrade];
    for (i=iGrade-1; i>=0; i--)
      dY= dY*dX+ A[i];
    }
  else dY= 0.00;
  return dY;
  }

/* Belegt eine Struktur mit Werten. Der String wird
   einer Ressource der DLL geladen.                     */
void DLL_EXP GetRecord(tSampleRec *r)
  {
  int  i;
  r->i = 1995;
  r->d = 0.123456789;
  for (i=0; i<r->cd; i++) r->ad[i] = (double) i;
/* Zugriff auf die Ressource dieser DLL
                           id           maxlength       */
  LoadString(hDllInstance, 1, &(r->sz), 64);
  return;
  }

} /* zu extern "C" */
