//Mit "MacHeaders68K" bzw. "MacHeadersPPC" kompilieren.
//Sonst weitere #include ntig: <Types.h> <QuickDraw.h> <Fonts.h>
//<Windows.h> <Dialogs.h> <Memory.h> <Events.h> <Menus.h>
#include <AppleEvents.h>

#include "globals.h"
#include "util.h"
#include "io.h"
#include "addr.h"
#include "win.h"
#include "print.h"
#include "main.h"

Boolean      gDone; /* true, wenn das Programm beendet wird */
EventRecord  gEvent;
AEEventHandlerUPP gOpenAppUPP, gOpenDocUPP, gPrintDocUPP, gQuitUPP;

void initMyMenus (void) /* Initialisiere die Mens */
{
	Handle myMBar;
	MenuHandle aMenu;
	
	myMBar = GetNewMBar (kMBAR);
	if (myMBar == NIL)
		errorHandler (kResourceError,true);
	SetMenuBar (myMBar); /* dem System neue Menleiste bergeben */
	DisposeHandle (myMBar);	/* brauchen wir jetzt nicht mehr */
	aMenu = GetMHandle (kAppleMenu);
	if (aMenu == NIL)
		errorHandler (kResourceError,true);
	AddResMenu (aMenu, 'DRVR');	/* Apple-Men vervollstndigen */
	DrawMenuBar (); /* Menleiste zeichnen  */
} /* initMyMenus */

void initToolbox (void) /* Toolbox-Manager initialisieren */
{
	MaxApplZone (); /* Heap bis zum Stack-Minimum wachsen lassen */
	MoreMasters (); /* Sofort unten auf dem Heap Master-Pointer ->*/
	MoreMasters (); /*-> anlegen, die _mitten_ auf dem Heap die ->*/
	MoreMasters (); /*-> dynamische Speicherverwaltung ->*/
	MoreMasters (); /*-> blockieren wrden. */
	InitGraf (&qd.thePort); /* QuickDraw initialisieren */
	InitFonts ();
	FlushEvents (everyEvent, 0);
	InitWindows (); /* WindowManager initialisieren */
	InitMenus ();
	TEInit ();
	InitDialogs (NIL);
	InitCursor (); /* Cursor als Pfeil */
}  /* initToolbox */

pascal OSErr aeOpenApp (AppleEvent messageIn, AppleEvent reply,
                        long handlerRefCon)
{
	winDoNew (); /* beim Start ein neues Fenster ffnen */
	return noErr; /* kein Fehler */
} /* aeOpenApp */

pascal OSErr aeOpenDocs (AppleEvent messageIn, AppleEvent reply,
                         long handlerRefCon)
{
	return ioOpenDocs (messageIn);
} /* aeOpenDoc */

pascal OSErr aePrintDocs (AppleEvent messageIn, AppleEvent reply,
                          long handlerRefCon)
{
	return ioPrintDocs (messageIn);
} /* aePrintDocs */

pascal OSErr aeQuitApp (AppleEvent messageIn, AppleEvent reply,
                        long handlerRefCon)
{
	gDone = true; /* Programm beenden */
	return noErr; /* kein Fehler */
} /* aeQuitApp */

void initAppleEvents (void) /* Wie auf Apple-Events reagieren? */
{
	OSErr err;
	
	gOpenAppUPP = NewAEEventHandlerProc (aeOpenApp);
	err = AEInstallEventHandler(kCoreEventClass, kAEOpenApplication,
	                             gOpenAppUPP, NIL, false);
	gOpenDocUPP = NewAEEventHandlerProc (aeOpenDocs);
	err = AEInstallEventHandler(kCoreEventClass, kAEOpenDocuments,
	                             gOpenDocUPP, NIL, false);
	gPrintDocUPP = NewAEEventHandlerProc (aePrintDocs);
	err = AEInstallEventHandler(kCoreEventClass, kAEPrintDocuments,
	                             gPrintDocUPP, NIL, false);
	gQuitUPP = NewAEEventHandlerProc (aeQuitApp);
	err = AEInstallEventHandler(kCoreEventClass, kAEQuitApplication,
	                             gQuitUPP, NIL, false);
	
} /* initAppleEvents */

void initModules (void) /* Programmodule initialisieren */
{
	gDone = false;
	initMyMenus (); /* einige Meneintrge disablen */
	initAppleEvents ();
	winInit (); /* Modul der Textfenster vorbereiten */
	addrInit (); /* Adressenmodul vorbereiten */
	prInit (); /* Druckmodul vorbereiten */	
} /* initModules */

void handleMenu (long menuHit) /* Meneintrag ausgewhlt */
{
	short   menuID, menuItem;
	Str255  accName;
	short   accNumber;
	
	menuID = HiWord (menuHit);/* Nummer des Mens */
	menuItem = LoWord (menuHit); /* Nummer des Meneintrages */
	switch (menuID)
	{
		case kAppleMenu: /* Apple-Men */
			switch (menuItem)
			{
				case kAMAbout: /* "ber dieses Programm" */
				   doAbout();
				   break;
				default: /* ein Apple-Men-Eintrag */
				   GetItem(GetMHandle(kAppleMenu),menuItem,accName);
				   accNumber = OpenDeskAcc(accName);
				   break;
			} /* switch */
			break;
		case kFileMenu: /* Ablage-Men */
			switch (menuItem)
			{
				case kFMNew: /* Neu */
					winDoNew ();
					break;
				case kFMOpen: /* ffnen... */
					ioOpenTextFile ();
					break;
				case kFMClose: /* Schlieen */
					winDoClose (FrontWindow ());
					break;
				case kFMSave: /* Sichern */
					ioSaveTextFile (FrontWindow ());
					break;
				case kFMSaveAs: /* Sichern unter... */
					ioSaveAsTextFile (FrontWindow ());
					break;
				case kFMPageSetup: /* Papierformat... */
					prPageSetup ();
					break;
				case kFMPrint: /* Drucken... */
					prPrintWin ();
					break;
				case kFMQuit:
					gDone = true; /* Programm beenden */
					break;
			} /* switch */
			break;
		case kEditMenu: /* Bearbeiten-Men */
			winDoMenu (menuItem);
			break;
		case kAddrMenu: /* Adressen-Men */
			addrDoMenu (menuItem);
			break;
	} /* switch */
	HiliteMenu (0); /* fertig, Mentitel nicht mehr hervorheben */
} /* handleMenu */

void doMouseDown (EventRecord *myEvent) /* ein Mausklick... */
{
	short thePart;
	WindowPtr myWindow;
	
	thePart = FindWindow (myEvent->where, &myWindow);
	switch (thePart) /* in welchen Bereich wurde geklickt? */
	{
		case inMenuBar: /* in die Menleiste */
			adjustMenus();
			handleMenu(MenuSelect( myEvent->where));
			break;
		case inSysWindow: /* in ein Systemfenster (Accessory...) */
			SystemClick(myEvent, myWindow);
			break;
		case inContent:	/* in ein Fenster */
			if (myWindow != FrontWindow()) /* Ist Fenster hinten? */
				SelectWindow(myWindow);	/* dann nach vorne */
			else
				winDoClick(myWindow, myEvent);
			break;
		case inDrag: /* Fenster verschieben */
		  DragWindow(myWindow,myEvent->where,&qd.screenBits.bounds);
		  break;
		case inGoAway: /* Fenster schlieen */
			if (TrackGoAway(myWindow, myEvent->where) &&
			                        winIsOurs (myWindow) )
				winDoClose(myWindow);
			break;
		case inGrow: /* Gre des Fensters verndern */
			if (winIsOurs (myWindow))
				winDoGrow (myWindow, myEvent);
			break;
		case inZoomIn: /* Fenster zoomen */
		case inZoomOut: /* ditto */
			if (TrackBox (myWindow, myEvent->where, thePart) &&
			                               winIsOurs (myWindow) )
				winDoZoom (myWindow, thePart);
	} /* switch */	
} /* doMouseDown */

void adjustMenus (void) /* vor Aufklappen ggf. Eintrge disablen */
{
	winAdjustMenus ();
	addrAdjustMenus ();
} /* adjustMenus */

void doActivate (WindowPtr whichWin, Boolean doActive)
/* Fenster aktivieren oder deaktivieren */
{
	winDoActivate (whichWin, doActive);
	/* Adrefenster nicht hier behandelt */
} /* doActivate */

void doUpdate (WindowPtr whichWin) /* Fenster updaten */
{
	if (winIsOurs (whichWin))
		if (! EmptyRgn (whichWin->visRgn))
			winDrawAll (whichWin);
} /* doUpdate */

unsigned long newSleepVal (void) /* neuer Wert fr sleep */
{
	long sleep;
	
	sleep = 500; /* 8 Sekunden */
	if (isInFront ()) /* wenn wir vorne sind, brauchen wir mehr */
		sleep = GetCaretTime ();
	return sleep;
} /* newSleepVal */

/* Bereich berechnen, in dem wir keine Mouse-Events bekommen */
/* nebenbei ndern wir auch den Cursor in die passende From */
void calcCursorRgn (RgnHandle region)
{
	WindowPtr   theWindow;
	RgnHandle   arrowRgn, iBeamRgn;
	Rect        iBeamRect;
	Point       mouse;
	
	theWindow = FrontWindow ();
	if ((isInFront ()) && (winIsOurs (theWindow)))
	{
		arrowRgn = NewRgn ();
		iBeamRgn = NewRgn ();
		RectRgn (arrowRgn, &qd.screenBits.bounds);
		iBeamRect = (*((documentPeek) theWindow)->docTE)->viewRect;
		SetPort (theWindow);
		LocalToGlobal (& topLeft(iBeamRect));
		LocalToGlobal (& botRight(iBeamRect));
		RectRgn (iBeamRgn,&iBeamRect); /* glob. Koord. Textfenster */
		DiffRgn (arrowRgn, iBeamRgn, arrowRgn);
		GetMouse (&mouse); /* da ist die Maus jetzt */
		LocalToGlobal (&mouse);	/* in globalen Koordinaten */
		if (PtInRgn (mouse, iBeamRgn))
		{
			SetCursor (*GetCursor (iBeamCursor));
			CopyRgn (iBeamRgn, region);
		} /* if */
		else
		{
			SetCursor (&qd.arrow);
			CopyRgn (arrowRgn, region);
		} /* else */
		DisposeRgn (arrowRgn);
		DisposeRgn (iBeamRgn);
	} /* if */
} /* calcCursorRgn */

void mainLoop (void)
{
	Boolean isEvent;
	Point   thePoint;
	char    key;
	OSErr   err;
	RgnHandle   cursorRgn;
	short       itemHit;
	DialogPtr   theDialog;
	long    myMessage;
	
	cursorRgn = NewRgn ();
	do 
	{	
		calcCursorRgn (cursorRgn);
		isEvent = WaitNextEvent (everyEvent, &gEvent,
		                     newSleepVal (),cursorRgn);
		if (IsDialogEvent (&gEvent)) /* fr nicht-modale Dialoge */
		{
			if (DialogSelect (&gEvent, &theDialog, &itemHit))
				addrHandleItemHit (itemHit);
			addrEventDispatch (&gEvent);
		}
		if (isEvent) /* ein Event ist zu verarbeiten */
			switch (gEvent.what)
			{
				case nullEvent:	/* kommt nur im Hintergrund */
					doIdle ();
					break;
				case mouseDown: /* mit der Maus wurde geklickt */
					doMouseDown (&gEvent);
					break;
				case keyDown:
				case autoKey: /* eine Taste wurde gedrckt */
					key = gEvent.message & charCodeMask;
					if (gEvent.modifiers & cmdKey)
					{
						adjustMenus ();
						handleMenu (MenuKey(key));
					}
					else
						winDoKey (&gEvent);
					break;
				case activateEvt: /* ein Fenster (de)aktivieren */
					doActivate ( (WindowPtr) gEvent.message,
					         (gEvent.modifiers & activeFlag) != 0 );
					break;
				case updateEvt: /* Fenster aktualisieren */
					doUpdate ((WindowPtr) gEvent.message);
					break;
				case diskEvt: /* eine Diskette wurde eingelegt */
					if (HiWord (gEvent.message) != noErr)
					{
						SetPt (&thePoint, -1, -1);
						err = DIBadMount (thePoint, gEvent.message);
					}
					break;
				case app4Evt: /* Suspend- und Resume-Events */
					myMessage = (gEvent.message >> 24) & 0x0FF;
					if (myMessage == 1)
						doActivate ( FrontWindow (),
						              ((gEvent.message&1) != 0) );
					if (myMessage == 0xFA) /* mouse-moved-Event */
						doIdle ();
					break;
				case kHighLevelEvent: /* ein AppleEvent*/
					err = AEProcessAppleEvent (&gEvent);
					break;
				default:
					doIdle ();
			} /* switch */
		else doIdle ();
	} while (gDone != true);
	DisposeRgn (cursorRgn);		
} /* mainLoop */

void main (void)
{
	initToolbox ();
	initModules ();
	mainLoop ();
	addrClose ();
	winCloseAll ();
} /* main */