unit OpDialog;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, FileCtrl;

type
  TOperationDialog = class(TForm)
    radDel: TRadioButton;
    radRen: TRadioButton;
    radMov: TRadioButton;
    btnOK: TButton;
    btnCancel: TButton;
    Label1: TLabel;
    edtSrc: TEdit;
    btnBrowseSource: TButton;
    edtDestMov: TEdit;
    btnBrowseDestMov: TButton;
    edtDestRen: TEdit;
    btnBrowseDestRen: TButton;
    dlgOpen: TOpenDialog;
    dlgSave: TSaveDialog;
    procedure edtDestRenChange(Sender: TObject);
    procedure edtDestMovChange(Sender: TObject);
    procedure btnBrowseSourceClick(Sender: TObject);
    procedure btnBrowseDestRenClick(Sender: TObject);
    procedure btnBrowseDestMovClick(Sender: TObject);
    procedure EnDisableOK(Sender: TObject);
    procedure btnOKClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    procedure Clear;
    procedure ValidateInput;
    procedure ValidateOutput;
  end;

var
  OperationDialog: TOperationDialog;

implementation

{$R *.DFM}

procedure TOperationDialog.Clear;
begin
  edtSrc.Text := '';
  edtDestMov.Text := '';
  edtDestRen.Text := '';
  radDel.Checked := true;
end;

procedure TOperationDialog.ValidateInput;
var srcPath, srcName, destFile, destPath, destName: String;
begin
  if edtSrc.Text <> ''
  then begin
    edtSrc.Text := ExcludeTrailingPathDelimiter(ExpandFileName(edtSrc.Text));
    if DirectoryExists(edtSrc.Text)
    then begin
      srcPath := edtSrc.Text;
      srcName := '';
    end
    else begin
      srcPath := ExtractFileDir(edtSrc.Text);
      srcName := ExtractFileName(edtSrc.Text);
    end;
  end
  else begin
    srcPath := '';
    srcName := '';
  end;
  if edtDestRen.Text <> ''
  then destFile := edtDestRen.Text
  else destFile := edtDestMov.Text;
  if destFile <> ''
  then begin
    if DirectoryExists(destFile)
    then begin
      destPath := destFile;
      destName := '';
    end
    else begin
      destPath := ExtractFileDir(destFile);
      destName := ExtractFileName(destFile);
    end;
  end
  else begin
    destPath := '';
    destName := '';
  end;
  if radDel.Checked
  then begin
    edtDestRen.Text := '';
    edtDestMov.Text := '';
  end
  else begin
    if (srcPath <> '') and (srcPath = destPath)
    then begin
      edtDestRen.Text := destName;
      edtDestMov.Text := '';
      radRen.Checked := true;
    end
    else begin
      if (srcName <> '') and (srcName = destName)
      then begin
        edtDestMov.Text := destPath;
        edtDestRen.Text := '';
        radMov.Checked := true;
      end
      else begin
        if radMov.Checked
        then begin
          edtDestMov.Text := destFile;
          edtDestRen.Text := '';
        end
        else begin
          edtDestRen.Text := destFile;
          edtDestMov.Text := '';
        end;
      end;
    end;
  end;
end;

procedure TOperationDialog.ValidateOutput;
var srcPath, srcName: String;
begin
  edtSrc.Text := ExcludeTrailingPathDelimiter(ExpandFileName(edtSrc.Text));
  if DirectoryExists(edtSrc.Text)
  then begin
    srcPath := edtSrc.Text;
    srcName := '';
  end
  else begin
    srcPath := ExtractFileDir(edtSrc.Text);
    srcName := ExtractFileName(edtSrc.Text);
  end;
  if radRen.Checked
  then begin
    if Pos('\', edtDestRen.Text) = 0
    then
      edtDestRen.Text := IncludeTrailingPathDelimiter(srcPath) + edtDestRen.Text;
  end;
  if radMov.Checked
  then begin
    if DirectoryExists(edtDestMov.Text)
    then
      edtDestMov.Text := IncludeTrailingPathDelimiter(edtDestMov.Text) + srcName;
  end;
end;

procedure TOperationDialog.edtDestRenChange(Sender: TObject);
begin
  radRen.Checked := true;
  EnDisableOK(Sender);
end;

procedure TOperationDialog.edtDestMovChange(Sender: TObject);
begin
  radMov.Checked := true;
  EnDisableOK(Sender);
end;

procedure TOperationDialog.btnBrowseSourceClick(Sender: TObject);
begin
  dlgOpen.FileName := edtSrc.Text;
  if dlgOpen.Execute
  then edtSrc.Text := dlgOpen.FileName;
end;

procedure TOperationDialog.btnBrowseDestRenClick(Sender: TObject);
begin
  if edtDestRen.Text <> ''
  then dlgSave.FileName := edtDestRen.Text
  else dlgSave.FileName := edtSrc.Text;
  if dlgSave.Execute
  then edtDestRen.Text := dlgSave.FileName;
end;

procedure TOperationDialog.btnBrowseDestMovClick(Sender: TObject);
var dir: String;
begin
  if edtDestMov.Text <> ''
  then dir := edtDestMov.Text
  else
    if edtSrc.Text <> ''
    then dir := ExtractFilePath(edtSrc.Text);
  if SelectDirectory('Zielverzeichnis auswhlen:', '', dir)
  then edtDestMov.Text := dir;
end;

procedure TOperationDialog.EnDisableOK(Sender: TObject);
begin
  btnOK.Enabled :=
    (edtSrc.Text <> '') and (
      radDel.Checked or
      (radRen.Checked and (edtDestRen.Text <> '')) or
      (radMov.Checked and (edtDestMov.Text <> '')));
end;

procedure TOperationDialog.btnOKClick(Sender: TObject);
begin
  ValidateOutput;
end;

procedure TOperationDialog.FormShow(Sender: TObject);
begin
  ValidateInput;
  if edtSrc.Text = ''
  then edtSrc.SetFocus
  else begin
    if radDel.Checked
    then edtSrc.SetFocus
    else if radRen.Checked
    then edtDestRen.SetFocus
    else edtDestMov.SetFocus;
  end;
end;

end.
