package haui.asteroid.control;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;

/**
 * Hauptprogramm der Emulator-Fernsteuerung.
 * 
 * @author Harald Bögeholz / c't
 * @author Bernhard Haumacher
 */
public class Main {

	public static void main(String[] args) throws IOException
	{
		if (args.length != 1)
		{
			System.err.println("Aufruf: haui.asteroid.control.Main <IP-Adresse>");
			System.exit(1);
		}

		InetAddress server_ip = InetAddress.getByName(args[0]);

		DatagramSocket sd = new DatagramSocket();

		Player player = new Player(sd, server_ip);
		player.run();
	}

}
