#!/bin/sh

# directory the game records are written to (files like
# asteroids-2008-05-14-16-38-32.gz)
# created if necessary
recorddir=~/Desktop/Asteroids-Aufzeichnungen


# our location
dir="$(pwd)/$(dirname "$0")"


userdialog () {
  local res
  res=$(osascript -e 'tell application "Finder" to activate' -e 'tell application "Finder" to display dialog "Zum Spielen bentigen Sie die ROM-Datei \"asteroid.zip\", die Sie per E-Mail an asteroids@ctmagazin.de anfordern knnen. Auf Ihrem Desktop, im Home-Verzeichnis oder in den Ordnern Dokumente und Downloads findet sie der Emulator automatisch.\n\nWie mchten Sie fortfahren?" buttons {"per E-Mail anfordern", "nochmal suchen", "beenden"} default button 3 with icon 2' 2>/dev/null)
  case "$res" in
    *anfordern) echo "mail" ;;
    *suchen) echo "search" ;;
    *) echo "cancel" ;;
  esac
}


findrom () {
  # look for the rom, which is distributed separately
  local roms path
  roms=
  for path in \
    "$dir/../Resources/mame/roms" \
    "$HOME" \
    "$HOME/Desktop" \
    "$HOME/Downloads" \
    "$HOME/Documents"
  do
    [ -e "$path/asteroid.zip" ] && roms=$path && break
  done
  echo "$roms"
}


roms=$(findrom)

while [ -z "$roms" ]
do
  # display a dialog to the user
  res=$(userdialog)
  case "$res" in
    mail) 
	open 'mailto:asteroids@ctmagazin.de?subject=Bitte%20um%20Zusendung%20der%20ROM-Images'
	exit
	;;
    search) 
        roms=$(findrom)
	;;
    cancel)
	exit
	;;
  esac
done

roms=${roms%asteroid.zip}
export DYLD_LIBRARY_PATH="$DYLD_LIBRARY_PATH:$dir/../Resources/"

mkdir -p "$recorddir"
# cd so that mameaster writes the records into that directory
cd "$recorddir"
mamebase="$dir/../Resources/mame"
"$mamebase/mameaster" asteroid \
    -rompath "$roms" -cfg_directory "$mamebase/cfg" \
    -window -brightness 1.0 -beam 2 -skip_gameinfo
