/*
 * Created on Apr 19, 2008
 *
 * (c) 2006-2007 dka - edv, media, webdesign
 *
 */
package com.dkaedv.asteroids.util;

import java.util.Comparator;

import com.dkaedv.asteroids.data.IPositionable;
import com.dkaedv.asteroids.data.Vector;

/**
 * Compares positionable objects by distance to a target vector.
 *
 * @author Daniel Kleine-Albers
 *
 */
public class DistanceComparator implements Comparator<IPositionable> {
    private Vector targetVector;

    public DistanceComparator(Vector targetVector) {
        super();
        this.targetVector = targetVector;
    }

    public DistanceComparator(IPositionable targetPositionable) {
        super();
        this.targetVector = targetPositionable.getPosition().getCurVector();
    }

    public int compare(IPositionable o1, IPositionable o2) {
        double d1 = VectorCalculations.getDistance(o1.getPosition().getCurVector(), targetVector);
        double d2 = VectorCalculations.getDistance(o2.getPosition().getCurVector(), targetVector);

        if (d1 < d2) {
            return -1;
        } else if (d1 > d2) {
            return 1;
        }

        return 0;
    }


}
