/*
 * Created on Apr 15, 2008
 *
 * (c) 2006-2007 dka - edv, media, webdesign
 *
 */
package com.dkaedv.asteroids.net;

public class FrameInfo {

    public static int VECTOR_RAM_SIZE = 1024;

    public static int MAME_DATAGRAM_SIZE = VECTOR_RAM_SIZE + 2; // Vectorramsize + 2

    public static int KEYS_DATAGRAM_SIZE = 8;

    public final static int OPCODE_LABS = 0xA;
    public final static int OPCODE_HALT = 0xB;
    public final static int OPCODE_JSRL = 0xC;
    public final static int OPCODE_RTSL = 0xD;
    public final static int OPCODE_JMPL = 0xE;
    public final static int OPCODE_SVEC = 0xF;

    public final static int JSRL_ASTEROID_TYPE_1 = 0x8F3;
    public final static int JSRL_ASTEROID_TYPE_2 = 0x8FF;
    public final static int JSRL_ASTEROID_TYPE_3 = 0x90D;
    public final static int JSRL_ASTEROID_TYPE_4 = 0x91A;
    public final static int JSRL_UFO = 0x929;
    public final static int JSRL_SHIP = 0xA6D; // for counting lives

    // Numbers and letters
    public final static int JSRL_SPACE = 0xB2C;
    public final static int JSRL_0 = 0xADD;
    public final static int JSRL_1 = 0xB2E;
    public final static int JSRL_2 = 0xB32;
    public final static int JSRL_3 = 0xB3A;
    public final static int JSRL_4 = 0xB41;
    public final static int JSRL_5 = 0xB48;
    public final static int JSRL_6 = 0xB4F;
    public final static int JSRL_7 = 0xB56;
    public final static int JSRL_8 = 0xB5B;
    public final static int JSRL_9 = 0xB63;

    public final static byte[] KEYS_SIGNATURE = { 'c', 't', 'm', 'a', 'm', 'e' };

    /** Hyperspace button pressed. */
    public final static int KEY_WARP       = 0x01;
    /** Fire button pressed. */
    public final static int KEY_FIRE       = 0x01 << 1;
    /** Thrust button pressed. */
    public final static int KEY_THRUST     = 0x01 << 2;
    /** Left button pressed. */
    public final static int KEY_RIGHT      = 0x01 << 3;
    /** Right button pressed. */
    public final static int KEY_LEFT       = 0x01 << 4;

    /**
     * Convert given byte interpreted as unsigned into an <code>int</code> value.
     *
     * This should be moved somewhere else.
     */
    public static int asInt(byte byteValue) {
        return ((int) byteValue) & 0xFF;
    }
}
