/*
 * Created on Jun 15, 2008
 *
 * (c) 2006-2007 dka - edv, media, webdesign
 *
 */
package com.dkaedv.asteroids.ki.rater;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.dkaedv.asteroids.data.GameStatus;
import com.dkaedv.asteroids.data.RatedTarget;
import com.dkaedv.asteroids.ki.TargetList;

public class SpeedRater extends BaseTargetRater {
    private Log log = LogFactory.getLog(SpeedRater.class);

    private double maxSpeed = 20;

    @Override
    public void rateTarget(GameStatus gameStatus, TargetList targetList,
            RatedTarget target) {

        double speed = target.getTarget().getPosition().getSpeed();

        if (speed == Double.POSITIVE_INFINITY) {
            return;
        }

        if (speed > maxSpeed) {
            log.debug("Incrementing maxSpeed to " + speed);
            maxSpeed = speed;
        }

        double score = (speed / maxSpeed) * 100;
        rateIt(target, (int) score);
    }

}
