/*
 * Created on Jun 15, 2008
 *
 * (c) 2006-2007 dka - edv, media, webdesign
 *
 */
package com.dkaedv.asteroids.ki.rater;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.dkaedv.asteroids.data.GameStatus;
import com.dkaedv.asteroids.data.RatedTarget;
import com.dkaedv.asteroids.ki.TargetList;
import com.dkaedv.asteroids.util.VectorCalculations;

public class DistanceRater extends BaseTargetRater {
    private Log log = LogFactory.getLog(DistanceRater.class);

    double maxDistance = 617;

    @Override
    public void rateTarget(GameStatus gameStatus, TargetList targetList, RatedTarget target) {
        double distance = VectorCalculations.getDistance(gameStatus.getShip(), target.getTarget());

        if (distance > maxDistance) {
            maxDistance = distance;
            log.debug("Incrementing maxDistance to " + maxDistance);
        }

        double score = (1 -(distance / maxDistance)) * 100;

        //log.debug("Rating for distance: " + distance + " maxDistance: " + maxDistance + " = " + score);

        rateIt(target, (int) score);
    }

}
