/*
 * Created on Jun 15, 2008
 *
 * (c) 2006-2007 dka - edv, media, webdesign
 *
 */
package com.dkaedv.asteroids.ki.rater;

import com.dkaedv.asteroids.data.GameStatus;
import com.dkaedv.asteroids.data.RatedTarget;
import com.dkaedv.asteroids.ki.TargetList;

/**
 * Target rater.
 *
 * A target rater adds a score between 0 and 100 to a target multiplied by the configured factor.
 *
 * The higher the score the more preferred the target is.
 *
 * @author Daniel Kleine-Albers
 *
 */
public abstract class BaseTargetRater {
    private double factor = 1;

    /**
     * Implementations implement this method.
     *
     * @param gameStatus
     * @param targetList
     * @param target
     */
    public abstract void rateTarget(GameStatus gameStatus, TargetList targetList, RatedTarget target);

    /**
     * Implementations call this to do the rating.
     *
     * @param target
     * @param score
     */
    protected void rateIt(RatedTarget target, int score) {
        target.rate((int) (((double)score) * factor));
    }

    /**
     * @param factor the factor to set
     */
    public void setFactor(double factor) {
        this.factor = factor;
    }


}
