/*
 * Created on Apr 18, 2008
 *
 * (c) 2006-2007 dka - edv, media, webdesign
 *
 */
package com.dkaedv.asteroids.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;

import javax.swing.JComponent;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.dkaedv.asteroids.data.GameInfo;
import com.dkaedv.asteroids.data.GameStatus;
import com.dkaedv.asteroids.ki.TargetList;

public class SpaceComponent extends JComponent {
    private static final long serialVersionUID = 1L;

    private static final Log log = LogFactory.getLog(SpaceComponent.class);

    private GameStatus gameStatus;
    private TargetList targetList;
    private AffineTransform trafo;
    private AffineTransform scaleTrafo;

    private static int width = 0;
    private static int height = 0;

    public SpaceComponent(int width, GameStatus gStatus, TargetList tList) {
        Dimension size = new Dimension(width, 3 * width / 4);
        setMaximumSize(size);
        setMinimumSize(size);
        setPreferredSize(size);
        setOpaque(true);
        setDoubleBuffered(true);

        SpaceComponent.width = width;
        SpaceComponent.height = 3 * width / 4;

        double scaling = width / (double) GameInfo.EXTENT;
        // NOTE: take care of y pointing upwards in Asteroids, but downwards on
        // screen
        trafo = AffineTransform.getTranslateInstance(0, GameInfo.MIN_Y
                - GameInfo.EXTENT);
        scaleTrafo = AffineTransform.getScaleInstance(scaling, -scaling);
        trafo.preConcatenate(scaleTrafo);

        gameStatus = gStatus;
        targetList = tList;
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(Color.black);
        g.fillRect(0, 0, getWidth(), getHeight());

        Graphics2D g2 = (Graphics2D) g.create();
        g2.transform(trafo);

        //((Graphics2D)g).transform(trafo);

        gameStatus.draw(g2, (Graphics2D) g);
        targetList.draw(g2, (Graphics2D) g);
    }

    public static int calcX(int origX) {
        int newX = (int) (((double)origX) / ((double)GameInfo.EXTENT_X) * ((double)width));
        //log.debug("OldX: " + origX + " NewX: " + newX);
        return newX;
    }

    public static int calcY(int origY) {
        int newY = (int) ((((double)GameInfo.EXTENT_Y) - ((double)origY) + ((double)GameInfo.MIN_Y)) / ((double)GameInfo.EXTENT_Y) * ((double)height));
        //log.debug("OldY: " + origY + " NewY: " + newY);
        return newY;
    }
}
