/*
 * Decompiled with CFR 0.152.
 */
package com.dkaedv.asteroids.util;

import com.dkaedv.asteroids.data.IPositionable;
import com.dkaedv.asteroids.data.Vector;
import com.dkaedv.asteroids.util.VectorCalculations;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistanceComparator
implements Comparator<IPositionable> {
    private Vector targetVector;

    public DistanceComparator(Vector targetVector) {
        this.targetVector = targetVector;
    }

    public DistanceComparator(IPositionable targetPositionable) {
        this.targetVector = targetPositionable.getPosition().getCurVector();
    }

    @Override
    public int compare(IPositionable o1, IPositionable o2) {
        double d2;
        double d1 = VectorCalculations.getDistance(o1.getPosition().getCurVector(), this.targetVector);
        if (d1 < (d2 = VectorCalculations.getDistance(o2.getPosition().getCurVector(), this.targetVector))) {
            return -1;
        }
        if (d1 > d2) {
            return 1;
        }
        return 0;
    }
}

