/*
 * Decompiled with CFR 0.152.
 */
package com.dkaedv.asteroids.net;

import com.dkaedv.asteroids.net.ConnectionInfo;
import com.dkaedv.asteroids.net.ConnectionStatus;
import com.dkaedv.asteroids.net.KeysDatagram;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DatagramSender
extends Thread {
    private Log log = LogFactory.getLog(DatagramSender.class);
    public static final long IDLE_SENDING_INTERVAL = 20L;
    private DatagramSocket socket;
    private KeysDatagram keysDatagram;
    private ConnectionStatus connectionStatus;
    private long lastSentTimestamp = 0L;

    public void run() {
        this.log.debug("Thread running");
        try {
            while (true) {
                if (this.lastSentTimestamp + 20L < System.currentTimeMillis()) {
                    this.sendPacket();
                }
                Thread.sleep(20L);
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void sendPacket() throws IOException {
        DatagramPacket dgram = new DatagramPacket(this.keysDatagram.getData(), 8);
        dgram.setAddress(InetAddress.getByName(ConnectionInfo.IP_ADDRESS));
        dgram.setPort(ConnectionInfo.PORT);
        this.socket.send(dgram);
        this.connectionStatus.addSentTimestamp(this.keysDatagram.getSentSerial(), System.currentTimeMillis());
        this.keysDatagram.packageSent();
        this.lastSentTimestamp = System.currentTimeMillis();
    }

    public void setSocket(DatagramSocket socket) {
        this.socket = socket;
    }

    public void setKeysDatagram(KeysDatagram keysDatagram) {
        this.keysDatagram = keysDatagram;
    }

    public void setConnectionStatus(ConnectionStatus connectionStatus) {
        this.connectionStatus = connectionStatus;
    }
}

