/*
 * Decompiled with CFR 0.152.
 */
package com.dkaedv.asteroids.ki;

import com.dkaedv.asteroids.data.IDrawable;
import com.dkaedv.asteroids.data.IPositionable;
import com.dkaedv.asteroids.ki.TargetList;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ConcurrentModificationException;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ShotTargetList
implements IDrawable {
    private static final int CIRCLE_SIZE = 40;
    private int listSize = 2;
    private ConcurrentLinkedQueue<IPositionable> shotTargets = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<Long> shotTargetTimes = new ConcurrentLinkedQueue();
    private TargetList targetList;

    public synchronized void registerShot(IPositionable target) {
        if (!this.shotTargets.contains(target)) {
            this.shotTargets.add(target);
            this.shotTargetTimes.add(System.currentTimeMillis());
        }
        while (this.shotTargets.size() > this.listSize) {
            this.removeOldestTarget();
        }
    }

    public synchronized boolean wasShotOn(IPositionable target) {
        int targetCount = this.targetList.getTargets().size();
        int newListSize = targetCount / 3;
        if (newListSize > 3) {
            newListSize = 3;
        }
        this.listSize = newListSize;
        while (this.shotTargets.size() > this.listSize) {
            this.removeOldestTarget();
        }
        if (this.shotTargets.size() > 0 && System.currentTimeMillis() - this.shotTargetTimes.peek() > 500L) {
            this.removeOldestTarget();
        }
        return this.shotTargets.contains(target);
    }

    public void draw(Graphics2D g, Graphics2D textG) {
        try {
            g.setColor(Color.GREEN);
            for (IPositionable target : this.shotTargets) {
                g.drawOval(target.getPosition().getCurVector().x - 20, target.getPosition().getCurVector().y - 20, 40, 40);
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    private void removeOldestTarget() {
        this.shotTargets.poll();
        this.shotTargetTimes.poll();
    }

    public void setTargetList(TargetList targetList) {
        this.targetList = targetList;
    }
}

