/*
 * Decompiled with CFR 0.152.
 */
package com.dkaedv.asteroids.ki;

import com.dkaedv.asteroids.data.IDrawable;
import com.dkaedv.asteroids.data.IPositionable;
import com.dkaedv.asteroids.data.RatedTarget;
import com.dkaedv.asteroids.data.Ship;
import com.dkaedv.asteroids.ki.BaseStrategy;
import com.dkaedv.asteroids.ki.TargetList;
import com.dkaedv.asteroids.ki.rater.BaseTargetRater;
import com.dkaedv.asteroids.util.DistanceComparator;
import com.dkaedv.asteroids.util.VectorCalculations;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiWeightingStrategy
extends BaseStrategy {
    private Log log = LogFactory.getLog(MultiWeightingStrategy.class);
    private List<BaseTargetRater> raters;
    private static final double TARGET_RECALC_DISTANCE = 100.0;
    private long runtime = 0L;

    @Override
    public void run() {
        while (true) {
            this.doProcessing();
            try {
                this.gameStatus.waitForUpdate();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doProcessing() {
        long startTime = System.currentTimeMillis();
        if (this.gameStatus.getShip() != null) {
            Ship ship = this.gameStatus.getShip();
            Vector<IDrawable> targetCandidates = new Vector<IDrawable>();
            targetCandidates.addAll(this.gameStatus.getAsteroids());
            if (this.gameStatus.getUfo() != null) {
                targetCandidates.add(this.gameStatus.getUfo());
            }
            Collections.sort(targetCandidates, new DistanceComparator(this.gameStatus.getShip()));
            if (targetCandidates.size() > 0) {
                IPositionable lastTarget = null;
                if (this.targetList.getFirstTarget() != null) {
                    lastTarget = this.targetList.getFirstTarget();
                }
                IPositionable firstTarget = lastTarget;
                if (lastTarget == null || VectorCalculations.getDistance(ship, lastTarget) > 100.0 || !targetCandidates.contains(lastTarget)) {
                    firstTarget = (IPositionable)targetCandidates.get(0);
                    RatedTarget firstRatedTarget = new RatedTarget(firstTarget);
                    for (IPositionable iPositionable : targetCandidates) {
                        RatedTarget ratedCandidate = new RatedTarget(iPositionable);
                        for (BaseTargetRater rater : this.raters) {
                            rater.rateTarget(this.gameStatus, this.targetList, ratedCandidate);
                        }
                        if (ratedCandidate.getRating() <= firstRatedTarget.getRating()) continue;
                        firstRatedTarget = ratedCandidate;
                        firstTarget = ratedCandidate.getTarget();
                    }
                }
                targetCandidates.remove(firstTarget);
                TargetList targetList = this.targetList;
                synchronized (targetList) {
                    this.targetList.getTargets().clear();
                    this.targetList.getTargets().add(firstTarget);
                    this.targetList.getTargets().addAll(targetCandidates);
                }
            }
            TargetList targetList = this.targetList;
            synchronized (targetList) {
                this.targetList.getTargets().clear();
            }
        }
        this.runtime = System.currentTimeMillis() - startTime;
    }

    public void setRaters(List<BaseTargetRater> raters) {
        this.raters = raters;
    }
}

