/*
 * Decompiled with CFR 0.152.
 */
package com.dkaedv.asteroids.data;

import com.dkaedv.asteroids.data.IDrawable;
import com.dkaedv.asteroids.data.Vector;
import com.dkaedv.asteroids.util.VectorCalculations;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Position
implements IDrawable {
    private ConcurrentLinkedQueue<Vector> vectorQueue = new ConcurrentLinkedQueue();
    private Vector curVector;
    private Log log = LogFactory.getLog(Position.class);

    public Position(int curX, int curY) {
        this.curVector = new Vector(curX, curY);
        this.vectorQueue.add(this.curVector);
    }

    public Vector getCurVector() {
        return this.curVector;
    }

    public Vector getLastVector() {
        return this.getOldestVector();
    }

    public Vector getPredictedVector(long ms) {
        Vector lastVector = this.getOldestVector();
        if (lastVector == null) {
            return this.curVector;
        }
        double targetTimeDiff = System.currentTimeMillis() + ms - this.curVector.timestamp;
        Vector movingVector = VectorCalculations.getDifference(lastVector, this.curVector);
        double movingTime = this.curVector.timestamp - lastVector.timestamp;
        double future_x = (double)this.curVector.x + (double)movingVector.x / movingTime * targetTimeDiff;
        double future_y = (double)this.curVector.y + (double)movingVector.y / movingTime * targetTimeDiff;
        Vector predVector = new Vector((int)future_x, (int)future_y);
        return predVector;
    }

    public double getSpeed() {
        Vector lastVector = this.getOldestVector();
        if (lastVector == null) {
            return 0.0;
        }
        double movingDistance = VectorCalculations.getDistance(lastVector, this.curVector);
        double movingTime = this.curVector.timestamp - lastVector.timestamp;
        return movingDistance / movingTime * 1000.0;
    }

    public void updatePosition(Vector newVector) {
        this.curVector = newVector;
        this.vectorQueue.add(this.curVector);
    }

    public void draw(Graphics2D g, Graphics2D textG) {
        Vector predVector = this.getPredictedVector(100L);
        g.setColor(Color.YELLOW);
        g.drawLine(this.curVector.x, this.curVector.y, predVector.x, predVector.y);
    }

    public double getAngle() {
        Vector v1 = this.getLastVector();
        Vector v2 = this.getCurVector();
        Vector diff = VectorCalculations.getDifferenceNormalized(v1, v2);
        return Math.atan2(diff.y, diff.x);
    }

    private Vector getOldestVector() {
        Vector v;
        while (true) {
            if (this.vectorQueue.isEmpty()) {
                return null;
            }
            v = this.vectorQueue.peek();
            if (System.currentTimeMillis() - v.timestamp <= 200L) break;
            this.vectorQueue.poll();
        }
        return v;
    }
}

