//
//  APTarget.m
//  APlayer
//
//  Created by Holger Sadewasser on 5/10/08.
//  Copyright 2008. All rights reserved.
//

#import "APTarget.h"


@implementation APTarget

// -------------------------------------------------------------------------------------
#pragma mark -
#pragma mark Initializers/Clean up
// -------------------------------------------------------------------------------------

-(id)initWithAngleByte:(uint8_t)iAngleByte direction:(int)iRotDirection frameOfShot:(unsigned)iFrame waiting:(unsigned)iWaitingTime
                object:(APObject *)iObject timeToShot:(int)iTimeToShot durationOfShot:(double)iDurationOfShot {

  self = [super init];
  if (self != nil) {
    mAngleByte = iAngleByte;
    mFrameOfShot = iFrame;
    mWaitingTime = iWaitingTime;
    mObject = iObject;
    [mObject retain];
    mDurationOfShot = iDurationOfShot;
    mTotalDuration = iTimeToShot + iDurationOfShot;
    mRotDirection = iRotDirection;
    mHeadingX = [iObject headingX];
    mHeadingY = [iObject headingY];
  }
  return self;
}


-(void)dealloc {
  [mObject release];
  [super dealloc];
}


// -------------------------------------------------------------------------------------
#pragma mark -
#pragma mark Instance Methods
// -------------------------------------------------------------------------------------

-(NSComparisonResult)compareDurationToTarget:(APTarget *)iTarget {
  
  if ( mDurationOfShot < [iTarget durationOfShot] )
    return NSOrderedAscending;
  else if ( mDurationOfShot > [iTarget durationOfShot] )
    return NSOrderedDescending;
  else
    return NSOrderedSame;
}

-(NSComparisonResult)compareTotalDurationToTarget:(APTarget *)iTarget {
  
  if ( mTotalDuration < [iTarget totalDuration] )
    return NSOrderedAscending;
  else if ( mTotalDuration > [iTarget totalDuration] )
    return NSOrderedDescending;
  else
    return NSOrderedSame;
}

-(NSComparisonResult)compareFramesToTarget:(APTarget *)iTarget {

  if ( mRotDirection < [iTarget rotationDirection] )
    return NSOrderedAscending;
  else if ( mRotDirection > [iTarget rotationDirection] )
    return NSOrderedDescending;
  else {
    if ( mFrameOfShot < [iTarget frameOfShot] )
      return NSOrderedAscending;
    else if ( mFrameOfShot > [iTarget frameOfShot] )
      return NSOrderedDescending;
    else
      return NSOrderedSame;
  }

}


-(APObject *)object {
  return mObject;
}

-(double)durationOfShot {
  return mDurationOfShot;
}

-(double)totalDuration {
  return mTotalDuration;
}

-(uint8_t)angleByte {
  return mAngleByte;
}

-(int)rotationDirection {
  return mRotDirection;
}

-(unsigned)frameOfShot {
  return mFrameOfShot;
}

-(unsigned)waitingTime {
  return mWaitingTime;
}

-(double)headingX {
  return mHeadingX;
}

-(double)headingY {
  return mHeadingY;  
}

@end
