//
//  APKeystroke.m
//  APlayer
//
//  Created by Holger Sadewasser on 5/10/08.
//  Copyright 2008. All rights reserved.
//

#import "APKeystroke.h"


@implementation APKeystroke

// -------------------------------------------------------------------------------------
#pragma mark -
#pragma mark Initializers/Clean up
// -------------------------------------------------------------------------------------

+(id)keystrokeWithKeys:(uint8_t)iKeys repeat:(unsigned)iRepeatCount {
  self = [[[APKeystroke alloc] initWithKeys:iKeys repeat:iRepeatCount target:nil] autorelease];
  return self;
}

+(id)keystrokeWithKeys:(uint8_t)iKeys repeat:(unsigned)iRepeatCount target:(APTarget *)iTarget {
  self = [[[APKeystroke alloc] initWithKeys:iKeys repeat:iRepeatCount target:iTarget] autorelease];
  return self;
}

-(id)initWithKeys:(uint8_t)iKeys repeat:(unsigned)iRepeatCount {
  return [self initWithKeys:iKeys repeat:iRepeatCount target:nil];
}

-(id)initWithKeys:(uint8_t)iKeys repeat:(unsigned)iRepeatCount target:(APTarget *)iTarget {
  self = [super init];
  if (self != nil) {
    mKeys = iKeys;
    mRepeatCount = iRepeatCount;
    mTarget = iTarget;
    [mTarget retain];
  }
  return self;  
}

-(void)dealloc {
  [mTarget release];
  [super dealloc];
}



// -------------------------------------------------------------------------------------
#pragma mark -
#pragma mark Instance Methods
// -------------------------------------------------------------------------------------

-(void)setKeys:(uint8_t)iKeys {
  mKeys = iKeys;
}

-(uint8_t)keys {
  return mKeys;
}

-(void)setRepeatCount:(unsigned)iRepeatCount {
  mRepeatCount = iRepeatCount;
}

-(unsigned)repeatCount {
  return mRepeatCount;
}

-(APTarget *)target {
  return mTarget;
}

-(void)sent {
  --mRepeatCount;
}

-(void)setTarget:(APTarget *)iTarget {
  [iTarget retain];
  [mTarget release];
  mTarget = iTarget;
}


@end
