//
//  APIOChannel.h
//  APlayer
//
//  Created by Holger Sadewasser on 4/20/08.
//  Copyright 2008. All rights reserved.
//

#import <Foundation/Foundation.h>


#pragma pack(1)

typedef struct APKeysPacket
{
  char signature[6];
  uint8_t keys;
  uint8_t ping;
} APKeysPacket_t;

typedef struct APFramePacket
{
  uint8_t vectorram[1024];
  uint8_t frameno;  // incremented for each frame
  uint8_t ping;     // server sends back the last received ping byte
} APFramePacket_t;

#pragma pack()


@protocol IOChannelDataCallback <NSObject>
- (void)dataReceived:(NSData *)iData;
@end

@protocol IOChannelWriteCallback <NSObject>
- (void)didSendKeys:(uint8_t)iKeys ping:(uint8_t)iPing timeToLive:(int)iTimeToLive;
@end


@interface APIOChannel : NSObject {

// -------------------------------------------------------------------------------------
#pragma mark -
#pragma mark Attributes
// -------------------------------------------------------------------------------------
  
  CFRunLoopSourceRef mSource;
  CFSocketRef mSocket;
  bool mFlgDataToSend;
  bool mFlgDataReceived;

  id <IOChannelDataCallback> mDataCallbackObject;
  id <IOChannelWriteCallback> mWriteCallbackObject;

  NSMutableData * mData;
  APKeysPacket_t * mKeysPacketPtr;
}

// -------------------------------------------------------------------------------------
#pragma mark -
#pragma mark Initializers/Clean up
// -------------------------------------------------------------------------------------

- (id)initWithAddress:(const char *)iAddress port:(const in_port_t)iPort;
- (id)initWithPort:(const in_port_t)iPort;
- (void)dealloc;


// -------------------------------------------------------------------------------------
#pragma mark -
#pragma mark Instance Methods
// -------------------------------------------------------------------------------------

- (void)setDataCallbackObject:(id <IOChannelDataCallback>)iObject;
- (void)setWriteCallbackObject:(id <IOChannelWriteCallback>)iObject;
- (void)readyToSend;
- (void)dataReceived:(NSData *)iData;
- (CFSocketError)sendKeys:(uint8_t)iKeys timeToLive:(int)iTimeToLive;
- (void)close;


@end
