//
//  APAsteroidsList.m
//  APlayer
//
//  Created by Holger Sadewasser on 5/24/08.
//  Copyright 2008. All rights reserved.
//

#import "APAsteroidsList.h"
#import "APObject.h"


@implementation APAsteroidsList

// -------------------------------------------------------------------------------------
#pragma mark -
#pragma mark Initializers/Clean up
// -------------------------------------------------------------------------------------

-(id)init {
  int i;
  
  self = [super initWithCapacity:MAX_NUM_ASTEROIDS+1];
  if (self != nil) {
    mCount = 0;
    mExplIndex1 = -1;
    mExplIndex2 = -1;
    for ( i = 0; i < MAX_NUM_ASTEROIDS+1; i++ ) {
      [self addObject:[[[APObject alloc] init] autorelease]];
    }
  }
  return self;
}



// -------------------------------------------------------------------------------------
#pragma mark -
#pragma mark Instance Methods
// -------------------------------------------------------------------------------------

-(void)setExplosionAtPosX:(int)iPosX posY:(int)iPosY {
  int i;
  APObject * object;
  APObjectTypes_t type;
  
  for ( i = 0; i < MAX_NUM_ASTEROIDS+1; i++ ) {
    object = [self objectAtIndex:i];
    type = [object type];
    if ( type == cAsteroid1 || type == cAsteroid2 || type == cAsteroid3 || type == cAsteroid4 ) {
      if ( [object isAtPosX:iPosX posY:iPosY] ) {
        if ( mExplIndex1 < 0 )
          mExplIndex1 = i;
        else 
          mExplIndex2 = i;
      }
    }
  }
  if ( mExplIndex1 >= 0 ) {
    if ( mExplIndex2 < 0 ) {
      [[self objectAtIndex:i] makeExplosion];
      --mCount;
      mExplIndex1 = -1;
    }
  }
}

-(void)updateWithListOfObjects:(NSArray *)iNewObjects frames:(uint8_t)iFrames {
  unsigned i, j;
  int numOfNewObj;
  APObject * newObject;
  APObject * object;
  APObjectTypes_t type;
  BOOL flgFound;
  
  if ( mExplIndex2 >= 0 ) {
    newObject = [iNewObjects objectAtIndex:mExplIndex1];
    object = [self objectAtIndex:mExplIndex1];
    // Compare with object at index of explosion
    if ( YES ) {
      [object makeExplosion];
    } else {
      [[self objectAtIndex:mExplIndex2] makeExplosion];
    }
    --mCount;
    mExplIndex1 = -1;
    mExplIndex2 = -1;
  }
  
  [self makeObjectsPerformSelector:@selector(decreaseTimeToLiveBy:) withObject:[NSNumber numberWithInt:(int)iFrames]];
  
  numOfNewObj = [iNewObjects count] - mCount;
  if ( numOfNewObj < 0 ) {
    NSLog(@"Asteroids array contains less objects than frame: %d", -numOfNewObj);
    numOfNewObj = 0;
  }

  j = 0;
  for ( i = 0; i < [iNewObjects count]; i++ ) {
    newObject = [iNewObjects objectAtIndex:i];
    do {
      flgFound = YES;
      object = [self objectAtIndex:j];
      type = [object type];
      if ( type == cAsteroid1 || type == cAsteroid2 || type == cAsteroid3 || type == cAsteroid4 ) {
        // Update the current object
        [object updateWithPosX:[newObject posXInt] posY:[newObject posYInt] frames:iFrames];
      } else if ( type == cEmpty && numOfNewObj > 0 ) {
        // Insert new object at current index
        [self replaceObjectAtIndex:j withObject:newObject];
        --numOfNewObj;
      } else {
        flgFound = NO;
      }
      ++j;
    } while ( flgFound == NO );
  }    
}


@end
