
#pragma once

#include "Saucer.h"

class SpaceShip;
class KeysPacket;


class TargetSystem
{
public:
	enum AnalyseResult
	{
		NoResult = 0,
		DirectShotPossible = 1,
		CollisionHeading = 2,
		DirectShotAfterWaiting = 3
	};

	TargetSystem(SpaceShip* agent);
	virtual ~TargetSystem(void);

	void takeAimAndShot(const int& time, KeysPacket* keys);

private:
	void shot(const int& time, KeysPacket* keys, MovingEntity* target);

	void sortAsteroids(void);

	AnalyseResult analyseMovingEntity(MovingEntity* entity);

	TargetSystem::AnalyseResult analyseForCrash(SpaceShip* spaceship, MovingEntity* entity);
	TargetSystem::AnalyseResult analyseForDirectShot(SpaceShip* spaceship, MovingEntity* entity);

	MovingEntity* aimShipAtNextTarget(KeysPacket* keys);

	MovingEntity* selectNextTargetFromCrashAsteroids(KeysPacket* keys, bool& shot);
	MovingEntity* selectNextTargetFromRestAsteroids(KeysPacket* keys, bool& shot);
	MovingEntity* huntSaucer(KeysPacket* keys, bool& shot);

	void turnShipAtTarget(MovingEntity* target, KeysPacket* keys, bool& shot, const double& rendezvousTime);
	
	Asteroid mAsteroids[MAX_ASTEROIDS]; // Ein Array fr die 'lokalen' Asteroiden
	int mAsteroidCount;

	std::list<Asteroid*> mCrashAsteroids;
	std::list<Asteroid*> mRestAsteroids;
	std::list<Asteroid*> mDirectShots;
	std::list<Asteroid*> mDirectShotsAfterWaiting;

	double calculateTurnAroundTime(const Vector2D& targetPos) const;

	Vector2D predictPosition(MovingEntity* entity, double& rendezvousTime, double& turnAroundTime) const;
	Vector2D predictPosition(const Vector2D& currentPosition, const Vector2D& prevPredictedPosition, const Vector2D velocity, double& rendezvousTime, double& turnAroundTime) const;

	bool multipleShotPossible(MovingEntity* entity) const;
	
	SpaceShip* mAgent;

	Saucer mSaucer;

	int mLastShotTime;
	int mAgentShotCount;
	double mPrecisionFactor; // Je kleiner desto ganauer. Maximal == 1.0
	int mShotRepetitionCounter;
	bool mDontWaitForAsteroids;
	double mMultibleShotPresicionDiv;
};
