
#pragma once

#include "movingentity.h"


class Shot : public MovingEntity
{
public:
	enum ShotSender
	{
		Saucer = 0,
		SpaceShip = 1
	};

	static const int ShotRadius = 2;

	Shot(void);
	virtual ~Shot(void);

	Shot& operator=(const Shot& rhs);

	void set(double x, double y);

	ShotSender getSender(void) const;
	void setSender(const ShotSender& sender);

	int getTargetId(void) const;
	void setTargetId(const int& targetId);

	int getLifeTime(void) const;

	void writeStatusToLog() const;

	virtual void calculateVelocityFromPrevPosition(const Vector2D& prevPosition, int frameCount);

private:
	Shot(const Shot& rhs); // Copy Constructor verbieten

	ShotSender mSender;
	int mTargetId;

	int mLifeTime;
};
