
#pragma once

#include "Vector2D.h"

class MovingEntity;


class PositionCalculator
{
public:
	static void tansferEntityToLocalSpace(const Vector2D translation, const double& rotation, MovingEntity* entity);
	static void tansferEntityToLocalSpaceInv(const Vector2D translation, const double& rotation, MovingEntity* entity);

	static Vector2D tansferPositionToLocalSpace(const Vector2D translation, const double& rotation, const Vector2D& position);
	static Vector2D tansferPositionToLocalSpaceInv(const Vector2D translation, const double& rotation, const Vector2D& position);

	static Vector2D wrapAroundLocalCoordinates(const Vector2D& position);
	static Vector2D wrapAroundWorldCoordinates(const Vector2D& position);

	static bool isPositionInWorldRange(const Vector2D &referencePos, const Vector2D &pos, double range);

	static void initializePositionArray(void);

	static double getRotation(const unsigned char& position);

private:
	static double RotationArray[256];

	PositionCalculator(void);
	virtual ~PositionCalculator(void);


};
