
#pragma once

#include "Vector2D.h"


class Matrix2D
{
public:
	Matrix2D(void);
    Matrix2D(const Matrix2D& rhs);

	virtual ~Matrix2D(void);

	Matrix2D& operator=(const Matrix2D& rhs);

	Matrix2D operator*(const Matrix2D& rhs) const;

	void setTranslation(const Vector2D& t);
	void setRotation(const double& a);
	void setScaling(const Vector2D& s);

	Vector2D transform(const Vector2D position) const;

private:
	// Aufbau:
	// mM[0] mM[1] mM[2]	
	// mM[3] mM[4] mM[5]
	// mM[6] mM[7] mM[8]
	double mM[9];
};
