
#include "StdAfx.h"
#include <Math.h>

#include "Calculator.h"

const double Calculator::PI = 3.14159265358979323846;

double Calculator::calculateRotationInRad(const Vector2D& vec)
{
    // Der Rotationswinkel ist abhngig davon, in welchem Quadranten wir liegen
    // x == 0, y > 0: 90      
    // x == 0, y < 0: 270      
    // x > 0, y == 0: 0      
    // x < 0, y == 0: 180      
    // Q1: x > 0, y > 0: Wert      
    // Q2: x < 0, y >= 0: 180 - Wert            
    // Q3: x < 0, y < 0: 180 + Wert            
    // Q4: x > 0, y < 0: 360 - Wert            

    // Sonderflle auswerten
    if (vec.getX() == 0)
    {
        if (vec.getY() > 0) { return PI / 2; }
        else { return (3 * PI / 2); }
    }

    if (vec.getY() == 0)
    {
        if (vec.getX() > 0) { return 0; }
        else { return PI; }
    }

    double rotation = 0.0;

    rotation = atan(abs(vec.getY()) / abs(vec.getX()));
    if ((vec.getX() < 0) && (vec.getY() > 0))
    {   // Q2
        rotation = PI - rotation;
    }
    else if ((vec.getX() < 0) && (vec.getY() < 0))
    {   // Q3
        rotation = PI + rotation;
    }
    else if ((vec.getX() > 0) && (vec.getY() < 0))
    {   // Q4
        rotation = 2 * PI - rotation;
    }
    
    if (rotation >= 2 * PI) { rotation = 0.0; }

    return rotation;
}


double Calculator::calculateRotationInDeg(const Vector2D& vec)
{
    double rotRad = calculateRotationInRad(vec);
    return (rotRad * 180 / PI);
}

double Calculator::fromRadToDeg(double angle)
{
    return (angle * 180 / PI);
}

double Calculator::fromDegToRad(double angle)
{
    return (angle * PI / 180);
}

int Calculator::isVector2LeftFromVector1(const Vector2D& vec1, const Vector2D& vec2)
{
    // Quelle: http://de.wikipedia.org/wiki/Graham_Scan

    // res > 0 wenn vec2 links von vec 1
    // res = 0 wenn vec2 auf vec1
    // res < 0 wenn vec2 rechts von vec1
    double res = vec1.getX() * vec2.getY() - vec1.getY() * vec2.getX();

	if (res == 0.0f) { return 0; }
	else if (res > 0.0f) { return 1; }
	else { return -1; }
}

double Calculator::getAngleBetweenVector2D(const Vector2D& vec1, const Vector2D& vec2)
{
	double lengthVec1 = vec1.getLength();
	double lengthVec2 = vec2.getLength();

	if ((lengthVec1 == 0) || (lengthVec2 == 0))
	{	// Winkel kann nicht bestimmt werden
		return 0.0;
	}

	double cos_alpha = (vec1.getX() * vec2.getX() + vec1.getY() * vec2.getY()) / (lengthVec1 * lengthVec2);
	return acos(cos_alpha);
}


