#ifndef VECTOR_H
#define VECTOR_H

#include <math.h>

class Vector : public Point
{
public:
	Vector() : Point() {};
	Vector(int a) : Point(a) {};
	Vector(double a) : Point(a) {};
	Vector(int a, int b) : Point(a, b) {};
	Vector(double a, double b) : Point(a, b) {};
	Vector(int a, int b, int c) : Point(a, b, c) {};
	Vector(double a, double b, double c) : Point(a, b, c) {};
	Vector(int n, int a[]) : Point(n, a) {};
	Vector(int n, double a[]) : Point(n, a) {};
	~Vector() {};

	Vector operator-();
	Vector operator~();
	friend Vector operator*(int, Vector);
	friend Vector operator*(double, Vector);
	friend Vector operator*(Vector, int);
	friend Vector operator*(Vector, double);
	friend Vector operator/(Vector, int);
	friend Vector operator/(Vector, double);

	Vector operator+(Vector);
	Vector operator-(Vector);
	double operator*(Vector);
	double operator|(Vector);
	Vector operator^(Vector);

	Vector& operator*=(double);
	Vector& operator/=(double);
	Vector& operator+=(Vector);
	Vector& operator-=(Vector);
	Vector& operator^=(Vector);

	double Length()
	{
		return sqrt(x*x + y*y + z*z);
	}

	double Length2()
	{
		return (x*x + y*y + z*z);
	}

	void Normalize();
	friend Vector Sum(int, int[], Vector[]);
	friend Vector Sum(int, double[], Vector[]);

	// Skalarprodukt
	double sprod(Vector _v);
	double sprod(Point _p);
	
	//Vektorprodukt
	Vector vprod(Vector _v);
	Vector vprod(Point _p);
};

#endif // VECTOR_H