#include "Point.h"
#include "Vector.h"

Vector Vector::operator-()
{
	Vector v;

	v.x = -this->x;
	v.y = -this->y;
	v.z = -this->z;
	v._dimensions = this->_dimensions;

	return v;
}

// unary 2D perp operator
Vector Vector::operator~()
{
	Vector v;

	v.x = -this->y;
	v.y = this->x;
	v.z = this->z;
	v._dimensions = this->_dimensions;

	return v;
}

// Scalar Multiplies
Vector operator*(int c, Vector w)
{
	Vector v;

	v.x = c * w.x;
	v.y = c * w.y;
	v.z = c * w.z;
	v.SetDimensions(w.dimensions());

	return v;
}

Vector operator*(double c, Vector w)
{
	Vector v;

	v.x = c * w.x;
	v.y = c * w.y;
	v.z = c * w.z;
	v.SetDimensions(w.dimensions());

	return v;
}

Vector operator*(Vector w, int c)
{
	Vector v;

	v.x = c * w.x;
	v.y = c * w.y;
	v.z = c * w.z;
	v.SetDimensions(w.dimensions());

	return v;
}

Vector operator*(Vector w, double c)
{
	Vector v;

	v.x = c * w.x;
	v.y = c * w.y;
	v.z = c * w.z;
	v.SetDimensions(w.dimensions());

	return v;
}

// Scalar Divides
Vector operator/(Vector w, int c)
{
	Vector v;

	v.x = w.x / c;
	v.y = w.y / c;
	v.z = w.z / c;
	v.SetDimensions(w.dimensions());

	return v;
}

Vector operator/(Vector w, double c)
{
	Vector v;

	v.x = w.x / c;
	v.y = w.y / c;
	v.z = w.z / c;
	v.SetDimensions(w.dimensions());

	return v;
}

Vector Vector::operator+(Vector w )
{
	Vector v;

	v.x = this->x + w.x;
	v.y = this->y + w.y;
	v.z = this->z + w.z;
	v._dimensions = max(this->_dimensions, w.dimensions());

	return v;
}

Vector Vector::operator-(Vector w)
{
	Vector v;

	v.x = this->x - w.x;
	v.y = this->y - w.y;
	v.z = this->z - w.z;
	v._dimensions = max(this->_dimensions, w.dimensions());

	return v;
}

// Inner Dot Product
double Vector::operator*(Vector w)
{
	return this->x * w.x + this->y * w.y + this->z * w.z;
}

// 2D Exterior Perp Product
double Vector::operator|(Vector w)
{
	return this->x * w.y - this->y * w.x;
}

// 3D Exterior Cross Product
Vector Vector::operator^(Vector w)
{
	Vector v;

	v.x = this->y * w.z - this->z * w.y;
	v.y = this->z * w.x - this->x * w.z;
	v.z = this->x * w.y - this->y * w.x;
	v._dimensions = 3;

	return v;
}

// vector scalar mult
Vector& Vector::operator*=(double c)
{        
	this->x *= c;
	this->y *= c;
	this->z *= c;

	return *this;
}

// vector scalar div
Vector& Vector::operator/=(double c)
{
	this->x /= c;
	this->y /= c;
	this->z /= c;

	return *this;
}

// vector increment
Vector& Vector::operator+=(Vector w)
{
	this->x += w.x;
	this->y += w.y;
	this->z += w.z;
	this->_dimensions = max(this->_dimensions, w.dimensions());

	return *this;
}
        
// vector decrement
Vector& Vector::operator-=(Vector w)
{
	this->x -= w.x;
	this->y -= w.y;
	this->z -= w.z;
	this->_dimensions = max(this->_dimensions, w.dimensions());

	return *this;
}

// 3D exterior cross product
Vector& Vector::operator^=(Vector w)
{
	double ox = this->x;
	double oy = this->y;
	double oz = this->z;

	this->x = oy * w.z - oz * w.y;
	this->y = oz * w.x - ox * w.z;
	this->z = ox * w.y - oy * w.x;
	this->_dimensions = 3;

	return *this;
}

// convert to unit length
void Vector::Normalize()
{
	double length = sqrt(this->x*this->x + this->y*this->y + this->z*this->z);

	if (length == 0)
	{
		return;                 
	}

	this->x /= length;
	this->y /= length;
	this->z /= length;
}

// vector sum
Vector Sum(int n, int c[], Vector w[])
{
	int maxd = 0;
	Vector  v;

	for (int i = 0; i < n; i++)
	{
		if (w[i].dimensions() > maxd)
		{
			maxd = w[i].dimensions();
		}
	}

	v.SetDimensions( maxd);

	for (int i = 0; i < n; i++)
	{
		v.x += c[i] * w[i].x;
		v.y += c[i] * w[i].y;
		v.z += c[i] * w[i].z;
	}

	return v;
}

// vector sum
Vector Sum(int n, double c[], Vector w[])
{  
	int maxd = 0;
	Vector  v;

	for (int i = 0; i < n; i++)
	{
		if (w[i].dimensions() > maxd)
		{
			maxd = w[i].dimensions();
		}
	}

	v.SetDimensions( maxd);

	for (int i = 0; i < n; i++)
	{
		v.x += c[i] * w[i].x;
		v.y += c[i] * w[i].y;
		v.z += c[i] * w[i].z;
	}

	return v;
}

// Skalarprodukt
double Vector::sprod(Vector _v)
{
	return (this->x * _v.x + this->y * _v.y + this->z * _v.z) / sqrt(this->x * this->x + this->y * this->y + this->z * this->z) * sqrt(_v.x * _v.x + _v.y * _v.y + _v.z * _v.z);
}
double Vector::sprod(Point _p)
{
	return (this->x * _p.x + this->y * _p.y + this->z * _p.z) / sqrt(this->x * this->x + this->y * this->y + this->z * this->z) * sqrt(_p.x * _p.x + _p.y * _p.y + _p.z * _p.z);
}

// Vektorprodukt
Vector Vector::vprod(Vector _v)
{
	Vector v;

	v.x = this->y * _v.z - this->z * _v.y;
	v.y = this->z * _v.x - this->x * _v.z;
	v.z = this->x * _v.y - this->y * _v.x;
	v.SetDimensions(3);

	return v;
}
Vector Vector::vprod(Point _p)
{
	Vector v;

	v.x = this->y * _p.z - this->z * _p.y;
	v.y = this->z * _p.x - this->x * _p.z;
	v.z = this->x * _p.y - this->y * _p.x;
	v.SetDimensions(3);

	return v;
}

