#include "Point.h"
#include "Vector.h"

Point::Point()
{
	
	this->_dimensions = 2;
	//this->_dimensions = 3;
	this->x = this->y = this->z = 0;
} // Point::Point

Point::Point(int a)
{
	this->_dimensions = 1;
	
	this->x = a;
	this->y = this->z = 0;
} // Point::Point

Point::Point(double a)
{
	this->_dimensions = 1;
	
	this->x = a;
	this->y = this->z = 0;
} // Point::Point

Point::Point(int a, int b)
{
	this->_dimensions = 2;
	
	this->x = a;
	this->y = b;
	this->z = 0;
} // Point::Point

Point::Point(double a, double b)
{
	this->_dimensions = 2;
	
	this->x = a;
	this->y = b;
	this->z = 0;
} // Point::Point

Point::Point(int a, int b, int c)
{
	this->_dimensions = 3;
	
	this->x = a;
	this->y = b;
	this->z = c;
} // Point::Point

Point::Point(double a, double b, double c)
{
	this->_dimensions = 3;
	
	this->x = a;
	this->y = b;
	this->z = c;
} // Point::Point

Point::Point(int n, int a[])
{
	this->x = this->y = this->z = 0;

	switch (this->_dimensions = n)
	{
		case 3:
			this->z = a[2];
		case 2:
			this->y = a[1];
		case 1:
			this->x = a[0];
			break;
	}
} // Point::Point

Point::Point(int n, double a[])
{
	this->x = this->y = this->z = 0.0;

	switch (this->_dimensions = n)
	{
		case 3:
			this->z = a[2];
		case 2:
			this->y = a[1];
		case 1:
			this->x = a[0];
			break;
	}
} // Point::Point

istream& operator>>(istream& input, Point& P)
{
	char c;

	input >> c;
	input >> P.x;
	input >> c;

	if (c == ')')
	{
		P.SetDimensions(1);

		return input;
	}

	input >> P.y;
	input >> c;

	if (c == ')')
	{
		P.SetDimensions(2);

		return input;
	}

	input >> P.z;
	P.SetDimensions(3);
	input >> c;

	return input;
} // operator>>

ostream& operator<<(ostream& output, Point P)
{
	switch (P.dimensions())
	{
		case 1:
			output << "(" << P.x << ")";
			break;
		case 2:
			output << "(" << P.x << ", " << P.y << ")";
			break;
		case 3:
			output << "(" << P.x << ", " << P.y << ", " << P.z << ")";
			break;
	}

	return output;
} // operator<<

int Point::SetDimensions(int n)
{
	switch (n)
	{
		case 1:
			this->y = 0;
		case 2:
			this->z = 0;
		break;
	}

	return this->_dimensions = n;
} // Point::SetDimensions

int Point::operator==(Point Q)
{
	if (this->_dimensions != Q.dimensions())
	{
		return 0;
	}

	switch (this->_dimensions)
	{
		case 1:
			return (this->x == Q.x);
		case 2:
			return (this->x == Q.x && this->y == Q.y);
		case 3:
		default:
			return (this->x == Q.x && this->y == Q.y && this->z == Q.z);
	}
} // Point::operator==

int Point::operator!=(Point Q)
{
	if (this->_dimensions != Q.dimensions())
	{
		return 1;
	}

	switch (this->_dimensions)
	{
		case 1:
			return (this->x != Q.x);
		case 2:
			return (this->x != Q.x || this->y != Q.y);
		case 3:
		default:
			return (this->x != Q.x || this->y != Q.y || this->z != Q.z);
	}
} // Point::operator!=

Vector Point::operator-(Point Q)
{
	Vector v;
	v.x = this->x - Q.x;
	v.y = this->y - Q.y;
	v.z = this->z - Q.z;
	v._dimensions = max(this->_dimensions, Q.dimensions());

	return v;
} // Point::operator-

Point Point::operator+(Vector v)
{
	Point P;
	P.x = this->x + v.x;
	P.y = this->y + v.y;
	P.z = this->z + v.z;
	P._dimensions = max(this->_dimensions, v.dimensions());

	return P;
} // Point::operator+

Point Point::operator-(Vector v)
{
	Point P;
	P.x = this->x - v.x;
	P.y = this->y - v.y;
	P.z = this->z - v.z;
	P._dimensions = max(this->_dimensions, v.dimensions());

	return P;
} // Point::operator-

Point& Point::operator+=(Vector v)
{
	this->x += v.x;
	this->y += v.y;
	this->z += v.z;
	this->_dimensions = max(this->_dimensions, v.dimensions());

	return *this;
} // Point::operator+=

Point& Point::operator-=(Vector v)
{
	this->x -= v.x;
	this->y -= v.y;
	this->z -= v.z;
	this->_dimensions = max(this->_dimensions, v.dimensions());

	return *this;
} // Point::operator-=

Point operator*(int c, Point Q)
{
	Point P;
	P.x = c * Q.x;
	P.y = c * Q.y;
	P.z = c * Q.z;
	P._dimensions = Q.dimensions();

	return P;
} // operator*

Point operator*(double c, Point Q)
{
	Point P;
	P.x = c * Q.x;
	P.y = c * Q.y;
	P.z = c * Q.z;
	P._dimensions = Q.dimensions();

	return P;
} // operator*

Point operator*(Point Q, int c)
{
	Point P;
	P.x = c * Q.x;
	P.y = c * Q.y;
	P.z = c * Q.z;
	P._dimensions = Q.dimensions();

	return P;
} // operator*

Point operator*(Point Q, double c)
{
	Point P;
	P.x = c * Q.x;
	P.y = c * Q.y;
	P.z = c * Q.z;
	P._dimensions = Q.dimensions();

	return P;
} // operator*

Point operator/(Point Q, int c)
{
	Point P;
	P.x = Q.x / c;
	P.y = Q.y / c;
	P.z = Q.z / c;
	P._dimensions = Q.dimensions();

	return P;
} // operator/

Point operator/(Point Q, double c)
{
	Point P;
	P.x = Q.x / c;
	P.y = Q.y / c;
	P.z = Q.z / c;
	P._dimensions = Q.dimensions();

	return P;
} // operator/

Point operator+(Point Q, Point R)
{
	Point P;
	P.x = Q.x + R.x;
	P.y = Q.y + R.y;
	P.z = Q.z + R.z;
	P._dimensions = max(Q.dimensions(), R.dimensions());

	return P;
} // operator+

double Point::IsLeft(Point P1, Point P2)
{
	return (P1.x - this->x) * (P2.y - this->y) - (P2.x - this->x) * (P1.y - this->y);
} // Point::IsLeft

Point AffineSum(int n, int c[], Point Q[])
{
	int maxd = 0;
	int cs = 0;
	Point P;

	for (int i = 0; i < n; i++)
	{
		cs += c[i];

		if (Q[i].dimensions() > maxd)
		{
			maxd = Q[i].dimensions();
		}
	}

	for (int i = 0; i < n; i++)
	{
		P.x += c[i] * Q[i].x;
		P.y += c[i] * Q[i].y;
		P.z += c[i] * Q[i].z;
	}

	P._dimensions = maxd;

	return P;
} // AffineSum

Point AffineSum(int n, double c[], Point Q[])
{
	int maxd = 0;
	double cs = 0.0;
	Point P;

	for (int i = 0; i < n; i++)
	{
		cs += c[i];

		if (Q[i].dimensions() > maxd)
		{
			maxd = Q[i].dimensions();
		}
	}

	for (int i = 0; i < n; i++)
	{
		P.x += c[i] * Q[i].x;
		P.y += c[i] * Q[i].y;
		P.z += c[i] * Q[i].z;
	}

	P._dimensions = maxd;

	return P;
} // AffineSum

double Difference(Point P, Point Q)
{
	double dx = P.x - Q.x;
	double dy = P.y - Q.y;
	double dz = P.z - Q.z;

	return sqrt(dx * dx + dy * dy + dz * dz);
} // Difference

double Difference2(Point P, Point Q)
{
	double dx = P.x - Q.x;
	double dy = P.y - Q.y;
	double dz = P.z - Q.z;

	return (dx * dx + dy * dy + dz * dz);
} // Difference