// player.h: Spielstatus fr Asteroids
// Harald Bgeholz / c't

#include "comm.h"

static const int MAX_ASTEROIDS = 100;
static const int MAX_SHOTS = 10;

class Asteroid
{
public:
	Asteroid();
	int x;    // Koordinaten des Mittelpunkts
	int y;
	int dx;   // Bewegungsvektor
	int dy;
	int type; // 1 ... 4, uere Form
	int sf;   // scale factor: 0 = gro, 15 = mittel, 14 = klein

	void set(int x, int y, int type, int sf);
	void set(int x, int y, int type, int sf, Asteroid& previous);
};

class Shot
{
public:
	int x;
	int y;

	void set(int x, int y);
};

class GameStatus
{
public:
	bool ship_present;  // Schiff sichtbar
	int ship_x;         // Mittelpunkt des Schiffs
	int ship_y;
	int ship_dx;        // Blickrichtung des Schiffes
	int ship_dy;
	bool saucer_present;// UFO sichtbar
	int saucer_x;       // Mittelpunkt des UFOs
	int saucer_y;
	int saucer_size;    // Gre: 15 = gro, 14 = klein
	int saucer_dx;       // Bewegung des UFOs
	int saucer_dy;
	int nasteroids; // Anzahl Asteroiden
	Asteroid asteroids[MAX_ASTEROIDS];
	int nshots;     // Anzahl Schsse
	Shot shots[MAX_SHOTS];
    
	void clear(void);
	void InterpretScreen(FramePacket &packet, GameStatus* previousgame);
};
