/*
 * Decompiled with CFR 0.152.
 */
package org.joni;

public final class NameEntry {
    static final int INIT_NAME_BACKREFS_ALLOC_NUM = 8;
    final byte[] name;
    final int nameP;
    final int nameEnd;
    int backNum;
    int backRef1;
    int[] backRefs;

    public NameEntry(byte[] bytes, int p, int end) {
        this.name = bytes;
        this.nameP = p;
        this.nameEnd = end;
    }

    private void alloc() {
        this.backRefs = new int[8];
    }

    private void ensureSize() {
        if (this.backNum > this.backRefs.length) {
            int[] tmp = new int[this.backRefs.length << 1];
            System.arraycopy(this.backRefs, 0, tmp, 0, this.backRefs.length);
            this.backRefs = tmp;
        }
    }

    public void addBackref(int backRef) {
        ++this.backNum;
        switch (this.backNum) {
            case 1: {
                this.backRef1 = backRef;
                break;
            }
            case 2: {
                this.alloc();
                this.backRefs[0] = this.backRef1;
                this.backRefs[1] = backRef;
                break;
            }
            default: {
                this.ensureSize();
                this.backRefs[this.backNum - 1] = backRef;
            }
        }
    }

    public String toString() {
        StringBuilder buff = new StringBuilder(new String(this.name, this.nameP, this.nameEnd - this.nameP) + " ");
        if (this.backNum == 0) {
            buff.append("-");
        } else if (this.backNum == 1) {
            buff.append(this.backRef1);
        } else {
            for (int i = 0; i < this.backNum; ++i) {
                if (i > 0) {
                    buff.append(", ");
                }
                buff.append(this.backRefs[i]);
            }
        }
        return buff.toString();
    }
}

