
package de.caff.asteroid;

import de.caff.util.Sequence;

import java.util.LinkedList;

/**
 *  A sequence of frame preparers.
 */
public class FramePreparerSequence
  extends Sequence<FramePreparer>
  implements FramePreparer
{
  /**
   *  Default constructor.
   */
  public FramePreparerSequence()
  {
  }

  /**
   *  Constructor.
   *  @param preparers preparers to add in the given sequence
   */
  public FramePreparerSequence(FramePreparer ... preparers)
  {
    super(preparers);
  }

  /**
   * Prepare the frame(s).
   *
   * @param frameInfos the collected frame infos
   */
  public void prepareFrames(LinkedList<FrameInfo> frameInfos)
  {
    for (FramePreparer prep: sequence) {
      prep.prepareFrames(frameInfos);
    }
  }
}
