
package de.caff.asteroid;

import java.util.LinkedList;

/**
 *  Called by {@link de.caff.asteroid.Communication} before a frame is distributed to
 *  {@link de.caff.asteroid.FrameListener}s.
 *  Called each time a frame is added to the internal queue before any frame listeners see it.
 *
 *
 *  @see de.caff.asteroid.FramePreparerSequence
 */
public interface FramePreparer
{
  /**
   *  Prepare the frame(s).
   *  @param frameInfos the collected frame infos
   */
  void prepareFrames(LinkedList<FrameInfo> frameInfos);
}
