
package de.caff.asteroid;

import java.util.LinkedList;
import java.util.concurrent.LinkedBlockingQueue;


/**
 *  Not working yet.
 */
public class AsteroidPlayer
        implements Runnable,
                   FrameListener
{
  private LinkedList<FrameInfo> frames = new LinkedList<FrameInfo>();
  private LinkedBlockingQueue<FrameInfo> incomingFrames = new LinkedBlockingQueue<FrameInfo>();
  private Communication com;

  public AsteroidPlayer(Communication com)
  {
    this.com = com;
    com.setFramePreparer(new FramePreparerSequence(new SimpleVelocityPreparer(),
                                                   new ScoreFixer()));
    com.addFrameListener(new HallOfFameFiller(com, "ram"));
  }

  /**
   * Run in thread.
   * @see Thread#run()
   */
  public void run()
  {
    while (true) {
      try {
        FrameInfo info = incomingFrames.take();
        // todo: something cool ;-)
      } catch (InterruptedException e) {
        e.printStackTrace(System.err);
      }
    }
  }

  /**
   * Called each time a frame is received.
   * <p/>
   * <b>ATTENTION:</b> this is called from the communication thread!
   * Implementing classes must be aware of this and take care by synchronization or similar!
   *
   * @param frame the received frame
   */
  public void frameReceived(FrameInfo frame)
  {
    try {
      incomingFrames.put(frame);
    } catch (InterruptedException x) {
      x.printStackTrace(System.err);
    }
  }
}
