package se.jupp.asteroids;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;

public class Ufo extends GameObject {
    /** Shape used for big ufo. */
    private static final GeneralPath BIG = new GeneralPath();
    /** Shape used for small ufo. */
    private static final GeneralPath SMALL;
    static {
        int w = 24;
        int h = 8;
        BIG.moveTo(-w, 0);
        BIG.lineTo(w, 0);
        BIG.lineTo(w / 2, -h);
        BIG.lineTo(-w / 2, -h);
        BIG.lineTo(-w, 0);
        BIG.lineTo(-w / 2, h);
        BIG.lineTo(w / 2, h);
        BIG.lineTo(w, 0);
        BIG.moveTo(-h, h);
        BIG.lineTo(-2 * h / 3, 2 * h);
        BIG.lineTo(2 * h / 3, 2 * h);
        BIG.lineTo(h, h);

        SMALL = new GeneralPath(BIG);
        SMALL.transform(AffineTransform.getScaleInstance(0.5, 0.5));
    }

    /** Is this ufo big? */
    private final boolean big;
    int lastTurn;
    Position turnPos;

    public Ufo(Frame.UfoPos pos, int timeBorn) {
        super(pos, (pos.size == 15) ? 16 : 8, timeBorn);
        this.big = (pos.size == 15);
        //        System.out.println("New Ufo at " + pos);
        lastTurn = age;
        turnPos = pos;
    }

    void update(Frame.UfoPos pos) {
        super.update(pos);
        if (pos != null) {
            if (age - lastTurn <= 8) {
                this.pos = pos;
                velocity =
                        pos.subtract(turnPos).divide(age - lastTurn)
                            .normalize();
            } else {
                int deviation = pos.distanceSquared(this.pos.add(velocity));
                if (deviation > 20) {
                    lastTurn = age;
                    this.pos = pos;
                    this.turnPos = this.pos;
                    //                    System.out.println("" + this + " TURNED");
                } else {
                    this.pos = this.pos.add(velocity);
                    //                    System.out.println("" + this + " velocity ok");
                }
            }
        }

        if (pos == null) {
            // Destroyed!
            //            System.out.println("Ufo destroyed at " + this.pos);
        }
    }

    /**
     *  Get the size of the object.
     *
     *  The size returned by this method is half the length of a square which contains the object,
     *  so the object's bounding box is between (x - size, y - size) and (x + size, y + size).
     *  @return object size
     */
    public int getSize() {
        return big ? 16 : 8;
    }

    /**
     *  Draw the object.
     *  @param g graphics context
     */
    @Override
    public void draw(Graphics2D g) {
        if (dangerous)
            g.setColor(Color.RED);
        else
            g.setColor(Color.white);
        g.draw(AffineTransform.getTranslateInstance(pos.x(), pos.y())
            .createTransformedShape(big ? BIG : SMALL));

        drawVelocityVector(g);
        super.draw(g);
    }

    /**
     * Returns a string representation of the object.
     *
     * @return a string representation of the object.
     */
    @Override
    public String toString() {
        return "Ufo@" + pos;
    }
}
