/*
 * Decompiled with CFR 0.152.
 */
package se.jupp.asteroids;

import java.awt.Graphics2D;

public class Position {
    final int x;
    final int y;

    public Position() {
        this.x = 0;
        this.y = 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Position other = (Position)obj;
        if (this.x != other.x) {
            return false;
        }
        return this.y == other.y;
    }

    public Position(int pixel_x, int pixel_y) {
        this(pixel_x << 3, pixel_y << 3, true);
    }

    Position(int x, int y, boolean internal) {
        this.x = x;
        this.y = y;
    }

    public Position normalize() {
        int minX = -4096;
        int maxX = 4096;
        int minY = -3072;
        int maxY = 3072;
        int x0 = this.x;
        int y0 = this.y;
        while (x0 < minX) {
            x0 += maxX - minX;
        }
        while (x0 > maxX) {
            x0 -= maxX - minX;
        }
        while (y0 < minY) {
            y0 += maxY - minY;
        }
        while (y0 > maxY) {
            y0 -= maxY - minY;
        }
        return new Position(x0, y0, true);
    }

    public Position unnormalize() {
        int minX = 0;
        int maxX = 8192;
        int minY = 1024;
        int maxY = 7160;
        int x0 = this.x;
        int y0 = this.y;
        while (x0 < minX) {
            x0 += maxX - minX;
        }
        while (x0 > maxX) {
            x0 -= maxX - minX;
        }
        while (y0 < minY) {
            y0 += maxY - minY;
        }
        while (y0 > maxY) {
            y0 -= maxY - minY;
        }
        return new Position(x0, y0, true);
    }

    public int x() {
        return this.x >> 3;
    }

    public int y() {
        return this.y >> 3;
    }

    public Position subtract(Position b) {
        if (b != null) {
            return new Position(this.x - b.x, this.y - b.y, true);
        }
        return this;
    }

    public Position add(Position b) {
        if (b != null) {
            return new Position(this.x + b.x, this.y + b.y, true);
        }
        return this;
    }

    public Position multiply(int b) {
        return new Position(this.x * b, this.y * b, true);
    }

    public Position divide(int b) {
        return new Position(this.x / b, this.y / b, true);
    }

    public int length() {
        return (int)Math.sqrt(this.square());
    }

    public double getAngle() {
        return Math.atan2(this.y, this.x);
    }

    public int distanceSquared(Position other) {
        return this.subtract(other).normalize().square();
    }

    public Position matrixMultiply(double a, double b, double c, double d) {
        return new Position((int)Math.round(a * (double)this.x + b * (double)this.y), (int)Math.round(c * (double)this.x + d * (double)this.y), true);
    }

    public int dotProduct(Position b) {
        return this.x * b.x + this.y * b.y >> 6;
    }

    public int square() {
        return this.dotProduct(this);
    }

    public int crossProduct2D(Position b) {
        return this.x * b.y - this.y * b.x >> 6;
    }

    public void drawLine(Position b, Graphics2D g) {
        g.drawLine(this.x(), this.y(), b.x(), b.y());
        Position b2 = b.unnormalize();
        if (!b2.equals(b)) {
            Position t2 = b2.subtract(b.subtract(this));
            g.drawLine(t2.x(), t2.y(), b2.x(), b2.y());
        }
    }

    public void drawLine2(Position b, Graphics2D g) {
        Position b2 = b.subtract(this).add(this).normalize();
        if (!b2.equals(b)) {
            Position t2 = this.subtract(b).add(b);
            g.drawLine(this.x(), this.y(), b2.x(), b2.y());
            g.drawLine(t2.x(), t2.y(), b.x(), b.y());
        } else {
            g.drawLine(this.x(), this.y(), b.x(), b.y());
        }
    }

    public String toString() {
        return "<P " + (this.x >> 3) + " " + (this.y >> 3) + ", " + this.x + " " + this.y + ">";
    }

    public static int timeToCollision2(Position bp, Position bv, int radius) {
        double foo2;
        long bdx = bv.x;
        long bx0 = bp.x;
        long bdy = bv.y;
        long by0 = bp.y;
        long term = bdx * bx0 + bdy * by0;
        int d = radius << 3;
        long rootterm = 4L * term * term - 4L * (bdx * bdx + bdy * bdy) * (bx0 * bx0 + by0 * by0 - (long)(d * d));
        double root = Math.sqrt(rootterm);
        double foo = ((double)(-bdx * bx0 - bdy * by0) - root / 2.0) / (double)(bdx * bdx + bdy * bdy);
        if (foo < (foo2 = ((double)(-bdx * bx0 - bdy * by0) + root / 2.0) / (double)(bdx * bdx + bdy * bdy))) {
            if (foo >= 0.0) {
                return (int)(foo + 0.5);
            }
            if (foo2 >= 0.0) {
                return (int)(foo2 + 0.5);
            }
            return -1;
        }
        if (foo2 >= 0.0) {
            return (int)(foo2 + 0.5);
        }
        if (foo >= 0.0) {
            return (int)(foo + 0.5);
        }
        return -1;
    }

    public static int timeToCollision(Position ap, Position av, Position bp, Position bv, int radius) {
        double foo2;
        long adx = av.x;
        long ax0 = ap.x;
        long ady = av.y;
        long ay0 = ap.y;
        long bdx = bv.x;
        long bdy = bv.y;
        long bx0 = bp.x;
        long by0 = bp.y;
        long term = -ax0 * bdx - ay0 * bdy + adx * (ax0 - bx0) + bdx * bx0 + ady * (ay0 - by0) + bdy * by0;
        int d = radius << 3;
        long rootterm = 4L * term * term - 4L * (adx * adx + ady * ady - 2L * adx * bdx + bdx * bdx - 2L * ady * bdy + bdy * bdy) * (ax0 * ax0 + ay0 * ay0 - 2L * ax0 * bx0 + bx0 * bx0 - 2L * ay0 * by0 + by0 * by0 - (long)(d * d));
        double root = Math.sqrt(rootterm);
        double foo = ((double)(-adx * ax0 - ady * ay0 + ax0 * bdx + ay0 * bdy + adx * bx0 - bdx * bx0 + ady * by0 - bdy * by0) - root / 2.0) / (double)(adx * adx + ady * ady - 2L * adx * bdx + bdx * bdx - 2L * ady * bdy + bdy * bdy);
        if (foo < (foo2 = ((double)(-adx * ax0 - ady * ay0 + ax0 * bdx + ay0 * bdy + adx * bx0 - bdx * bx0 + ady * by0 - bdy * by0) + root / 2.0) / (double)(adx * adx + ady * ady - 2L * adx * bdx + bdx * bdx - 2L * ady * bdy + bdy * bdy))) {
            if (foo >= 0.0 && foo < 70.0) {
                return (int)(foo + 0.5);
            }
            if (foo2 >= 0.0 && foo2 < 70.0) {
                return (int)(foo2 + 0.5);
            }
            return -1;
        }
        if (foo2 >= 0.0 && foo2 < 70.0) {
            return (int)(foo2 + 0.5);
        }
        if (foo >= 0.0 && foo < 70.0) {
            return (int)(foo + 0.5);
        }
        return -1;
    }
}

