package de.heise.asteroid.model;

import de.heise.asteroid.Position;
import de.heise.asteroid.ScreenVector;
import de.heise.asteroid.engine.GameStatus;
import de.heise.asteroid.util.SimpleMath;

/**
 * The <code>Ship</code> class represents the players space ship. It is a 
 * <code>MovingObject</code> that also has an orientation. The orientation 
 * is the direction in which a shot can be fired.
 *  
 * @author Chr. Moellenberg
 * @see GameStatus
 */
public class Ship extends MovingObject {
   protected ScreenVector orientation;
   protected ScreenVector dir;
   protected int angle;

	/**
	 * Initializes a new space ship with the given position and orientation.
	 *
    * @param p the position of the <code>Ship</code>
	 * @param o the orientation of the <code>Ship</code>
	 * @param a the angle code of the orientation
	 */
	public Ship(Position p, ScreenVector o, int a) {
	   super(p);
		orientation = o;
		angle = a;
		dir = new ScreenVector(SimpleMath.astCos[angle], SimpleMath.astSin[angle]);
		speed = ScreenVector.NULL_VECTOR;
	}

	/**
	 * Returns the angle code of the orientation of the ship
	 * 
	 * @return the angle code in the range [0..255]
	 */
	public int getAngle() {
	   return angle;
	}

	/**
    * Returns the orientation of this <code>Ship</code>.
    * 
    * @return the orientation
    */
   public ScreenVector getOrientation() {
      return orientation;
   }

   public ScreenVector getDir() {
      return dir;
   }

   public void update(Position p, ScreenVector o, int a, ScreenVector sp) {
      pos = p;
      orientation = o;
      angle = a;
      dir = new ScreenVector(SimpleMath.astCos[angle], SimpleMath.astSin[angle]);
      speed = sp;
   }

   /* (non-Javadoc)
    * @see de.heise.asteroid.model.MovingObject#toString()
    */
   @Override
   public String toString() {
      StringBuilder str = new StringBuilder();
      str.append("ship:").append(super.toString()).append(';').append(orientation);
      return str.toString();
   }
}
