/**
 * File:    ScreenObject.java
 * Package: de.heise.asteroid.model
 * Created: 10.05.2008 00:09:08
 * Author:  Chr. Moellenberg
 *
 * Copyright (c) 2008 by Chr. Moellenberg
 */

package de.heise.asteroid.model;

import de.heise.asteroid.Position;
import de.heise.asteroid.ScreenVector;

/**
 * A <code>ScreenObject</code> represents an object on screen. It has a 
 * <code>Position</code>.
 * 
 * @author Chr. Moellenberg
 */
public class ScreenObject {
   protected Position pos;

   /**
    * Initializes the position. Note that all position values are "sub-space" 
    * co-ordinates.
    * 
    * @param p the position of this <code>ScreenObject</code>
    */
   public ScreenObject(Position p) {
      pos = p;
   }

   /**
    * Returns the position of the <code>ScreenObject</code>.
    * @return the position
    */
   public final Position getPos() {
      return pos;
   }

   /**
    * Sets the position of the <code>ScreenObject</code>.
    * 
    * @param p the position
    */
   public final void setPos(Position p) {
      pos = p;
   }

   /**
    * Computes the distance vector between <code>this</code> and <code>obj</code>.
    * 
    * @param obj the <code>ScreenObject</code> at a distance
    * @return the distance vector from <code>this</code> to <code>obj</code>
    */
   final public ScreenVector getDistanceTo(ScreenObject obj) {
      return pos.getDistanceTo(obj.getPos());
   }

   /* (non-Javadoc)
    * @see java.lang.Object#toString()
    */
   @Override
   public String toString() {
      return pos.toString();
   }
}
