/**
 * File:    Text.java
 * Package: de.heise.asteroid.model
 * Created: 23.05.2008 20:44:32
 * Author:  Chr. Moellenberg
 *
 * Copyright (c) 2008 by Chr. Moellenberg
 */

package de.heise.asteroid.engine;

import de.heise.asteroid.Position;
import de.heise.asteroid.model.ScreenObject;


/**
 * <code>Text</code> models a piece of text that appears on screen. It is a 
 * <code>ScreenObject</code> that also has a text.
 *
 * @author Chr. Moellenberg
 */
public class Text extends ScreenObject {
   String text;

   /**
    * Initializes the <code>ScreenText</code>. Note that the position is 
    * in screen co-ordinates (not sub-space)!
    * 
    * @param t the text
    * @param sp the screen position
    */
   public Text(String t, Position sp) {
      super(sp);
      text = t;
   }

   /**
    * Returns the actual text of this <code>Text</code> object.
    * 
    * @return the text
    */
   public String getText() {
      return text;
   }

   /* (non-Javadoc)
    * @see de.heise.asteroid.model.MovingObject#toString()
    */
   @Override
   public String toString() {
      StringBuilder str = new StringBuilder();
      str.append("text:'").append(text).append("';").append(super.toString());
      return str.toString();
   }
}
