/*
 * Decompiled with CFR 0.152.
 */
package de.heise.asteroid.model;

import de.heise.asteroid.Position;
import de.heise.asteroid.ScreenVector;
import de.heise.asteroid.engine.GameStatus;
import de.heise.asteroid.model.Target;

public class Asteroid
extends Target {
    private int type;
    private int size;
    private int radius;

    public Asteroid(Position p, ScreenVector sp, int t, int s) {
        super(p, sp);
        this.type = t;
        this.size = s;
        this.exploding = GameStatus.isExplosionType(t);
        switch (this.size) {
            case 14: {
                this.radius = 64;
                break;
            }
            case 15: {
                this.radius = 128;
                break;
            }
            default: {
                this.radius = 256;
            }
        }
    }

    public int getType() {
        return this.type;
    }

    public int getSize() {
        return this.size;
    }

    public int getRadius() {
        return this.radius;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("asteroid:").append(this.type).append(';').append(super.toString()).append(';').append(this.size);
        return str.toString();
    }
}

