/*
 * Decompiled with CFR 0.152.
 */
package de.heise.asteroid.engine;

import de.heise.asteroid.Position;
import de.heise.asteroid.comm.FramePacket;
import de.heise.asteroid.engine.GameStatus;
import de.heise.asteroid.engine.Text;
import java.util.LinkedList;
import java.util.List;

public class TextInterpreter {
    List<Text> strings;
    int state;
    GameStatus status;

    public TextInterpreter(GameStatus stat) {
        this.status = stat;
        this.strings = new LinkedList<Text>();
        this.state = 0;
    }

    public int getState() {
        return this.state;
    }

    public void interpretFrame(FramePacket fp) {
        int px = 0;
        int py = 0;
        int tx = 0;
        int ty = 0;
        StringBuilder strb = new StringBuilder();
        this.strings.clear();
        int initialJump = fp.getRamAt(0);
        if (initialJump != 57345 && initialJump != 57857) {
            System.err.println(String.format("Bad instruction in vector RAM[0]: %04x", initialJump));
            this.state = 99;
            return;
        }
        int pc = 1;
        block8: while (true) {
            int currentWord = fp.getRamAt(pc++);
            int op = currentWord >> 12;
            switch (op) {
                case 10: {
                    this.finalizeText(strb, tx, ty);
                    int nextWord = fp.getRamAt(pc++);
                    py = currentWord & 0x3FF;
                    px = nextWord & 0x3FF;
                    continue block8;
                }
                case 11: {
                    this.checkState();
                    return;
                }
                case 12: {
                    int addr = currentWord & 0xFFF;
                    if (addr >= 2680 && addr <= 2915) {
                        if (strb.length() == 0) {
                            tx = px;
                            ty = py;
                        }
                        strb.append(TextInterpreter.getCharByAddr(addr));
                        continue block8;
                    }
                    this.finalizeText(strb, tx, ty);
                    continue block8;
                }
                case 13: {
                    System.err.println(String.format("Unexpected RTSL instruction in vector RAM[%03x]", pc - 1));
                    return;
                }
                case 14: {
                    System.err.println(String.format("Unexpected JMPL instruction in vector RAM[%03x]", pc - 1));
                    return;
                }
                case 15: {
                    continue block8;
                }
            }
        }
    }

    private void finalizeText(StringBuilder strb, int sx, int sy) {
        if (strb.length() > 0) {
            String s = strb.toString();
            strb.setLength(0);
            this.strings.add(new Text(s, new Position(sx, sy)));
        }
    }

    private void checkState() {
        int newState = 0;
        for (Text t : this.strings) {
            String s = t.getText().trim();
            int x = t.getPos().getX();
            int y = t.getPos().getY();
            if (s.startsWith("STARTKNO") || s.startsWith("HOECHSTE")) {
                this.status.setPlayerNo(0);
                newState = 1;
                continue;
            }
            if (s.equals("SPIELENDE")) {
                newState = 4;
                continue;
            }
            if (s.equals("SPIELER 1")) {
                this.status.setPlayerNo(1);
                newState = 2;
                continue;
            }
            if (s.equals("SPIELER 2")) {
                this.status.setPlayerNo(2);
                newState = 2;
                continue;
            }
            if (s.startsWith("IHR ERGE") || s.startsWith("BITTE GE") || s.startsWith("ZUR BUCH") || s.startsWith("WENN BUC")) {
                newState = 5;
                continue;
            }
            if (y == 876) {
                switch (x) {
                    case 100: {
                        this.status.setScore(1, this.parseNumber(s));
                        break;
                    }
                    case 480: {
                        this.status.setScore(0, this.parseNumber(s));
                        break;
                    }
                    case 768: {
                        this.status.setScore(2, this.parseNumber(s));
                        break;
                    }
                    default: {
                        System.out.println("Undetected: " + t);
                        break;
                    }
                }
                continue;
            }
            if (newState == 5 && x == 400 & y == 228) {
                this.status.setInitials(t.getText());
                continue;
            }
            if (newState == 1 && x == 380 & y <= 668) continue;
            System.out.println("Undetected: " + t);
        }
        if (newState == 0) {
            if (this.state == 2) {
                this.state = 3;
            }
        } else {
            this.state = newState;
        }
    }

    private int parseNumber(String s) {
        int number = 0;
        int i = 0;
        while (i < s.length()) {
            int digit = "O123456789".indexOf(s.charAt(i));
            if (digit < 0) {
                return -1;
            }
            number = 10 * number + digit;
            ++i;
        }
        return number;
    }

    private static char getCharByAddr(int addr) {
        switch (addr) {
            case 2680: {
                return 'A';
            }
            case 2688: {
                return 'B';
            }
            case 2701: {
                return 'C';
            }
            case 2707: {
                return 'D';
            }
            case 2715: {
                return 'E';
            }
            case 2723: {
                return 'F';
            }
            case 2730: {
                return 'G';
            }
            case 2739: {
                return 'H';
            }
            case 2746: {
                return 'I';
            }
            case 2753: {
                return 'J';
            }
            case 2759: {
                return 'K';
            }
            case 2765: {
                return 'L';
            }
            case 2770: {
                return 'M';
            }
            case 2776: {
                return 'N';
            }
            case 2781: {
                return 'O';
            }
            case 2787: {
                return 'P';
            }
            case 2794: {
                return 'Q';
            }
            case 2803: {
                return 'R';
            }
            case 2811: {
                return 'S';
            }
            case 2818: {
                return 'T';
            }
            case 2824: {
                return 'U';
            }
            case 2830: {
                return 'V';
            }
            case 2835: {
                return 'W';
            }
            case 2842: {
                return 'X';
            }
            case 2847: {
                return 'Y';
            }
            case 2854: {
                return 'Z';
            }
            case 2860: {
                return ' ';
            }
            case 2862: {
                return '1';
            }
            case 2866: {
                return '2';
            }
            case 2874: {
                return '3';
            }
            case 2881: {
                return '4';
            }
            case 2888: {
                return '5';
            }
            case 2895: {
                return '6';
            }
            case 2902: {
                return '7';
            }
            case 2907: {
                return '8';
            }
            case 2915: {
                return '9';
            }
        }
        return '?';
    }
}

